(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    106325,       3176]*)
(*NotebookOutlinePosition[    107154,       3204]*)
(*  CellTagsIndexPosition[    107110,       3200]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Damped Oscillations", "Subtitle"],

Cell[TextData[
"This notebook contains executable versions of several examples from the \
text."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Example 6.4 M", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[DoublePrime]",
                    MultilineFunction->None], "[", "t", "]"}], "+", 
                RowBox[{"26", " ", 
                  RowBox[{
                    SuperscriptBox["x", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], 
                "+", \(25\ x[t]\)}], "==", "0"}], ",", \(x[0] == 4\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", "20"}]}], 
          "}"}], ",", \(x[t]\), ",", "t"}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{x[
            t] \[Rule] \[ExponentialE]\^\(\(-25\)\ t\)\ \((\(-1\) + 
                5\ \[ExponentialE]\^\(24\ t\))\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s1[t_] = x[t] /. %\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(\(-25\)\ t\)\ \((\(-1\) + 
          5\ \[ExponentialE]\^\(24\ t\))\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[s1[t], {t, 0, 1}]\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 -0.393957 0.222177 [
[.21429 .0379 -9 -9 ]
[.21429 .0379 9 0 ]
[.40476 .0379 -9 -9 ]
[.40476 .0379 9 0 ]
[.59524 .0379 -9 -9 ]
[.59524 .0379 9 0 ]
[.78571 .0379 -9 -9 ]
[.78571 .0379 9 0 ]
[.97619 .0379 -3 -9 ]
[.97619 .0379 3 0 ]
[.01131 .16149 -18 -4.5 ]
[.01131 .16149 0 4.5 ]
[.01131 .27257 -6 -4.5 ]
[.01131 .27257 0 4.5 ]
[.01131 .38366 -18 -4.5 ]
[.01131 .38366 0 4.5 ]
[.01131 .49475 -6 -4.5 ]
[.01131 .49475 0 4.5 ]
[.01131 .60584 -18 -4.5 ]
[.01131 .60584 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .0504 m
.21429 .05665 L
s
[(0.2)] .21429 .0379 0 1 Mshowa
.40476 .0504 m
.40476 .05665 L
s
[(0.4)] .40476 .0379 0 1 Mshowa
.59524 .0504 m
.59524 .05665 L
s
[(0.6)] .59524 .0379 0 1 Mshowa
.78571 .0504 m
.78571 .05665 L
s
[(0.8)] .78571 .0379 0 1 Mshowa
.97619 .0504 m
.97619 .05665 L
s
[(1)] .97619 .0379 0 1 Mshowa
.125 Mabswid
.07143 .0504 m
.07143 .05415 L
s
.11905 .0504 m
.11905 .05415 L
s
.16667 .0504 m
.16667 .05415 L
s
.2619 .0504 m
.2619 .05415 L
s
.30952 .0504 m
.30952 .05415 L
s
.35714 .0504 m
.35714 .05415 L
s
.45238 .0504 m
.45238 .05415 L
s
.5 .0504 m
.5 .05415 L
s
.54762 .0504 m
.54762 .05415 L
s
.64286 .0504 m
.64286 .05415 L
s
.69048 .0504 m
.69048 .05415 L
s
.7381 .0504 m
.7381 .05415 L
s
.83333 .0504 m
.83333 .05415 L
s
.88095 .0504 m
.88095 .05415 L
s
.92857 .0504 m
.92857 .05415 L
s
.25 Mabswid
0 .0504 m
1 .0504 L
s
.02381 .16149 m
.03006 .16149 L
s
[(2.5)] .01131 .16149 1 0 Mshowa
.02381 .27257 m
.03006 .27257 L
s
[(3)] .01131 .27257 1 0 Mshowa
.02381 .38366 m
.03006 .38366 L
s
[(3.5)] .01131 .38366 1 0 Mshowa
.02381 .49475 m
.03006 .49475 L
s
[(4)] .01131 .49475 1 0 Mshowa
.02381 .60584 m
.03006 .60584 L
s
[(4.5)] .01131 .60584 1 0 Mshowa
.125 Mabswid
.02381 .07262 m
.02756 .07262 L
s
.02381 .09483 m
.02756 .09483 L
s
.02381 .11705 m
.02756 .11705 L
s
.02381 .13927 m
.02756 .13927 L
s
.02381 .1837 m
.02756 .1837 L
s
.02381 .20592 m
.02756 .20592 L
s
.02381 .22814 m
.02756 .22814 L
s
.02381 .25036 m
.02756 .25036 L
s
.02381 .29479 m
.02756 .29479 L
s
.02381 .31701 m
.02756 .31701 L
s
.02381 .33923 m
.02756 .33923 L
s
.02381 .36145 m
.02756 .36145 L
s
.02381 .40588 m
.02756 .40588 L
s
.02381 .4281 m
.02756 .4281 L
s
.02381 .45032 m
.02756 .45032 L
s
.02381 .47253 m
.02756 .47253 L
s
.02381 .51697 m
.02756 .51697 L
s
.02381 .53919 m
.02756 .53919 L
s
.02381 .5614 m
.02756 .5614 L
s
.02381 .58362 m
.02756 .58362 L
s
.02381 .02818 m
.02756 .02818 L
s
.02381 .00596 m
.02756 .00596 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .49475 m
.03279 .53097 L
.04262 .5596 L
.04758 .57049 L
.05288 .57995 L
.05785 .58702 L
.06244 .59218 L
.06788 .59683 L
.07075 .5987 L
.07379 .6003 L
.07642 .60139 L
.07889 .60217 L
.08028 .60252 L
.08159 .60278 L
.08312 .60302 L
.08383 .60311 L
.08451 .60318 L
.08577 .60327 L
.08692 .60331 L
.08815 .60332 L
.08884 .6033 L
.08948 .60328 L
.09055 .60321 L
.09173 .6031 L
.09296 .60296 L
.0941 .60279 L
.09675 .60228 L
.09916 .60169 L
.10458 .59994 L
.11449 .59548 L
.12366 .5902 L
.14443 .57541 L
.18369 .54191 L
.22144 .50751 L
.26165 .47101 L
.30033 .43683 L
.34147 .4018 L
.3811 .36941 L
.41921 .33948 L
.45977 .3089 L
.49881 .28067 L
.54031 .25191 L
.58029 .22535 L
.61876 .20084 L
.65968 .17582 L
.69908 .15273 L
.73697 .13141 L
.77731 .10962 L
.81613 .08951 L
.85741 .069 L
Mistroke
.89717 .05007 L
.93541 .03259 L
.97611 .01475 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{17, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`005Oooool00ol0003ooooooooo
o`3oooooo`;ooooo000Eooooo`03o`000?oooooooooo0?oooooo0_ooool001Gooooo0_l0000Yoooo
o`;o00001?ooool01?l0003oooooooooooooool5o`0002Cooooo0_l00004ooooo`03o`000?oooooo
oooo00?ooooo0ol0000Tooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00009?ooool2
o`0000Cooooo00?o0000ooooooooool00_ooool3o`0002[ooooo0ol00006ooooo`005Oooool00ol0
003oooooooooo`0Wooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo00008ooo
ool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo02;ooooo00Co0000oooooooooooo
00001oooool01Ol0003ooooooooooooooooo000002;ooooo00Co0000oooooooooooo00001oooool0
1Ol0003ooooooooooooooooo000002[ooooo00?o0000ooooooooool01Oooool001Gooooo00?o0000
ooooooooool09oooool01?l0003oooooooooool00009ooooo`03o`000?oooooooooo02?ooooo00Co
0000oooooooooooo00001oooool5o`0002?ooooo00Co0000oooooooooooo00001oooool01Ol0003o
oooooooooooooooo000002;ooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooo
oooo000002[ooooo0_l00006ooooo`005Oooool00ol0003oooooooooo`0Wooooo`04o`000?oooooo
ooooo`0000[ooooo00?o0000ooooooooool08_ooool01?l0003oooooooooool00007ooooo`04o`00
0?ooooooooooo`0002Cooooo00Co0000oooooooooooo00001oooool4o`0002?ooooo00Co0000oooo
oooooooo00002?ooool3o`0002Wooooo0ol00007ooooo`005Oooool00ol0003oooooooooo`0Woooo
o`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Sooooo`04o`000?oo
ooooooooo`0000Sooooo00?o0000ooooool000009?ooool01?l0003oooooooooool00007ooooo`03
o`000?oooooooooo02Cooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo
000002Gooooo0ol00002ooooo`03o`000?oooooooooo00Gooooo000Eooooo`03o`000?oooooooooo
02Oooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000002?ooooo00Co
0000oooooooooooo00002Oooool2o`0002Cooooo00Co0000oooooooooooo00002?ooool00ol0003o
ooooooooo`0Sooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000S
ooooo`;o00001?ooool2o`0000Oooooo000Eooooo`;o0000:Oooool2o`0000Wooooo0ol0000Uoooo
o`;o00002oooool00ol0003oooooooooo`0Sooooo`;o00002_ooool2o`0002Cooooo0_l00009oooo
o`?o00008_ooool2o`0000Oooooo00?o0000ooooooooool01Oooool001Gooooo00?o0000oooooooo
ool0k_ooool2o`00017ooooo000Eooooo`03o`000?oooooooooo0>_ooooo0ol0000Cooooo`005Ooo
ool00ol0003oooooooooo`3Yooooo`;o00005_ooool001Gooooo00?o0000ooooooooool0i_ooool3
o`0001Sooooo000Eooooo`03o`000?oooooooooo0>Cooooo0_l0000Kooooo`003_ooooooo`0000co
0000000Eooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`08ooooo`?o00002oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Cooooo
000Eooooo`03o`000?oooooooooo0=gooooo0_l0000Rooooo`005Oooool00ol0003oooooooooo`3K
ooooo`;o00009?ooool001Gooooo00?o0000ooooooooool0fOooool2o`0002Kooooo000Eooooo`;o
0000f?ooool2o`0002Sooooo000Eooooo`03o`000?oooooooooo0=Gooooo0_l0000Zooooo`005Ooo
ool00ol0003oooooooooo`3Dooooo`03o`000?oooooooooo02[ooooo000Eooooo`03o`000?oooooo
oooo0=;ooooo0_l0000]ooooo`005Oooool00ol0003oooooooooo`3@ooooo`;o0000;oooool001Go
oooo00?o0000ooooooooool0c_ooool2o`00037ooooo000Eooooo`;o0000cOooool2o`0003?ooooo
000Eooooo`03o`000?oooooooooo0<[ooooo0_l0000eooooo`005Oooool00ol0003oooooooooo`38
ooooo`;o0000=oooool001Gooooo00?o0000ooooooooool0a_ooool2o`0003Wooooo000Eooooo`03
o`000?oooooooooo0<Cooooo0_l0000kooooo`005Oooool00ol0003oooooooooo`32ooooo`;o0000
?Oooool001Gooooo0_l00031ooooo`;o0000?oooool001Gooooo00?o0000ooooooooool0_oooool0
0ol0003oooooooooo`0oooooo`005Oooool00ol0003oooooooooo`2mooooo`;o0000@_ooool001Go
oooo00?o0000ooooooooool0^oooool2o`0004Cooooo000Eooooo`03o`000?oooooooooo0;Wooooo
0_l00016ooooo`005Oooool00ol0003oooooooooo`2gooooo`;o0000B?ooool001Gooooo0_l0002g
ooooo`03o`000?oooooooooo04Sooooo000Eooooo`03o`000?oooooooooo0;Cooooo0_l0001;oooo
o`005Oooool00ol0003oooooooooo`2booooo`;o0000COooool001Gooooo00?o0000ooooooooool0
/Oooool00ol0003oooooooooo`1=ooooo`001Ol00003ooooo`03o`000?oooooooooo00;ooooo0ol0
0005ooooo`03o`000?oooooooooo0:oooooo0_l0001@ooooo`0000Goooooo`000?ooooooooooo`00
0007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`2]ooooo`;o0000
D_ooool000;ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`;o0000[Ooo
ool00ol0003oooooooooo`1Booooo`000oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0Z_ooool2o`0005Gooooo00001Ol0003ooooooooooooooooo
000000Oooooo1?l00005ooooo`03o`000?oooooooooo0:Sooooo0_l0001Gooooo`0000Go0000oooo
ooooooooooooo`000007ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0Yoooool0
0ol0003oooooooooo`1Gooooo`0000Coooooo`000?l0003o00002?ooool5o`0000Cooooo00?o0000
ooooooooool0YOooool2o`0005[ooooo000Eooooo`03o`000?oooooooooo0:Cooooo00?o0000oooo
ooooool0F_ooool001Gooooo0_l0002Sooooo`;o0000GOooool001Gooooo00?o0000ooooooooool0
X?ooool2o`0005oooooo000Eooooo`03o`000?oooooooooo09oooooo00?o0000ooooooooool0Gooo
ool001Gooooo00?o0000ooooooooool0WOooool2o`0006;ooooo000Eooooo`03o`000?oooooooooo
09cooooo00?o0000ooooooooool0H_ooool001Gooooo00?o0000ooooooooool0V_ooool2o`0006Go
oooo000Eooooo`;o0000VOooool2o`0006Oooooo000Eooooo`03o`000?oooooooooo09Oooooo00?o
0000ooooooooool0Ioooool001Gooooo00?o0000ooooooooool0UOooool2o`0006[ooooo000Eoooo
o`03o`000?oooooooooo09?ooooo0_l0001/ooooo`005Oooool00ol0003oooooooooo`2Booooo`03
o`000?oooooooooo06cooooo000Eooooo`03o`000?oooooooooo093ooooo0_l0001_ooooo`005Ooo
ool2o`00093ooooo00?o0000ooooooooool0Koooool001Gooooo00?o0000ooooooooool0SOooool2
o`0007;ooooo000Eooooo`03o`000?oooooooooo08_ooooo0_l0001dooooo`005Oooool00ol0003o
ooooooooo`2:ooooo`03o`000?oooooooooo07Cooooo000Eooooo`03o`000?oooooooooo08Sooooo
0_l0001gooooo`005Oooool00ol0003oooooooooo`27ooooo`03o`000?oooooooooo07Oooooo000E
ooooo`;o0000Q_ooool2o`0007[ooooo000Eooooo`03o`000?oooooooooo08Cooooo00?o0000oooo
ooooool0N_ooool001Gooooo00?o0000ooooooooool0Poooool00ol0003oooooooooo`1kooooo`00
3Oooool3o`0000Gooooo00?o0000ooooooooool0POooool2o`0007kooooo000<ooooo`05o`000?oo
ooooooooooooool000001?ooool00ol0003oooooooooo`20ooooo`03o`000?oooooooooo07kooooo
000@ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0O_ooool2o`00087ooooo000>
ooooo`;o00001Oooool2o`0007kooooo00?o0000ooooooooool0POooool0013ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`1looooo`03o`000?oooooooooo08;ooooo000<ooooo`05
o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`1jooooo`;o0000QOooool000go
oooo0ol00005ooooo`03o`000?oooooooooo07Wooooo00?o0000ooooooooool0QOooool001Gooooo
00?o0000ooooooooool0Moooool2o`0008Sooooo000Eooooo`;o0000Moooool00ol0003ooooooooo
o`28ooooo`005Oooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo08Wooooo000Eoooo
o`03o`000?oooooooooo07?ooooo0_l0002<ooooo`005Oooool00ol0003oooooooooo`1booooo`03
o`000?oooooooooo08cooooo000Eooooo`03o`000?oooooooooo073ooooo0_l0002?ooooo`005Ooo
ool00ol0003oooooooooo`1_ooooo`03o`000?oooooooooo08oooooo000Eooooo`;o0000Koooool0
0ol0003oooooooooo`2@ooooo`005Oooool00ol0003oooooooooo`1/ooooo`;o0000Toooool001Go
oooo00?o0000ooooooooool0Joooool00ol0003oooooooooo`2Cooooo`005Oooool00ol0003ooooo
ooooo`1Yooooo`;o0000U_ooool001Gooooo00?o0000ooooooooool0J?ooool00ol0003ooooooooo
o`2Fooooo`005Oooool00ol0003oooooooooo`1Wooooo`03o`000?oooooooooo09Oooooo000Eoooo
o`;o0000I_ooool2o`0009[ooooo000Eooooo`03o`000?oooooooooo06Cooooo00?o0000oooooooo
ool0V_ooool001Gooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`2Kooooo`005Ooo
ool00ol0003oooooooooo`1Rooooo`03o`000?oooooooooo09cooooo000Eooooo`03o`000?oooooo
oooo063ooooo0_l0002Oooooo`005Oooool00ol0003oooooooooo`1Oooooo`03o`000?oooooooooo
09oooooo000Eooooo`;o0000Goooool00ol0003oooooooooo`2Pooooo`005Oooool00ol0003ooooo
ooooo`1Mooooo`03o`000?oooooooooo0:7ooooo000Eooooo`03o`000?oooooooooo05_ooooo0_l0
002Tooooo`005Oooool00ol0003oooooooooo`1Jooooo`03o`000?oooooooooo0:Cooooo00001?oo
oooo0000o`000?l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`000?oooooo
oooo05Wooooo00?o0000ooooooooool0YOooool00005o`000?ooooooooooooooool000001oooool0
1Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0F?ooool00ol0003ooooooooo
o`2Vooooo`001?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00;ooooo0_l0001G
ooooo`;o0000ZOooool000;ooooo0_l0000<ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0EOooool00ol0003oooooooooo`2Yooooo`001?ooool00ol0003oooooooooo`05ooooo`Co
00001Oooool00ol0003oooooooooo`1Dooooo`03o`000?oooooooooo0:[ooooo00001Ol0003ooooo
oooooooooooo000000Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1Cooooo`03
o`000?oooooooooo0:_ooooo00001?oooooo0000o`000?l00008ooooo`Go00001?ooool00ol0003o
ooooooooo`1Booooo`03o`000?oooooooooo0:cooooo000Eooooo`03o`000?oooooooooo053ooooo
0_l0002_ooooo`005Oooool2o`00053ooooo00?o0000ooooooooool0[oooool001Gooooo00?o0000
ooooooooool0C_ooool00ol0003oooooooooo`2`ooooo`005Oooool00ol0003oooooooooo`1=oooo
o`03o`000?oooooooooo0;7ooooo000Eooooo`03o`000?oooooooooo04_ooooo0_l0002dooooo`00
5Oooool00ol0003oooooooooo`1:ooooo`03o`000?oooooooooo0;Cooooo000Eooooo`03o`000?oo
oooooooo04Wooooo00?o0000ooooooooool0]Oooool001Gooooo0_l00019ooooo`03o`000?oooooo
oooo0;Kooooo000Eooooo`03o`000?oooooooooo04Oooooo00?o0000ooooooooool0]oooool001Go
oooo00?o0000ooooooooool0AOooool2o`000;[ooooo000Eooooo`03o`000?oooooooooo04Cooooo
00?o0000ooooooooool0^_ooool001Gooooo00?o0000ooooooooool0@oooool00ol0003ooooooooo
o`2kooooo`005Oooool00ol0003oooooooooo`12ooooo`03o`000?oooooooooo0;cooooo000Eoooo
o`;o0000@_ooool00ol0003oooooooooo`2mooooo`005Oooool00ol0003oooooooooo`10ooooo`03
o`000?oooooooooo0;kooooo000Eooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0
_oooool001Gooooo00?o0000ooooooooool0?_ooool00ol0003oooooooooo`30ooooo`005Oooool0
0ol0003oooooooooo`0mooooo`03o`000?oooooooooo0<7ooooo000Eooooo`03o`000?oooooooooo
03_ooooo0_l00034ooooo`005Oooool2o`0003_ooooo00?o0000ooooooooool0a?ooool001Gooooo
00?o0000ooooooooool0>Oooool00ol0003oooooooooo`35ooooo`005Oooool00ol0003ooooooooo
o`0hooooo`03o`000?oooooooooo0<Kooooo000>ooooo`?o00001?ooool00ol0003oooooooooo`0g
ooooo`03o`000?oooooooooo0<Oooooo000?ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool0=_ooool00ol0003oooooooooo`38ooooo`003?ooool5o`0000Cooooo00?o0000oooooooo
ool0=Oooool00ol0003oooooooooo`39ooooo`003?ooool01?l0003oooooooooool00005ooooo`;o
0000=Oooool00ol0003oooooooooo`3:ooooo`003Oooool00ol0003oooooo`000005ooooo`03o`00
0?oooooooooo03?ooooo00?o0000ooooooooool0boooool000kooooo0_l00005ooooo`03o`000?oo
oooooooo03;ooooo00?o0000ooooooooool0c?ooool000oooooo00?o0000ooooooooool00oooool2
o`00037ooooo0_l0003?ooooo`005Oooool2o`00033ooooo00?o0000ooooooooool0coooool001Go
oooo0_l0000_ooooo`03o`000?oooooooooo0=3ooooo000Eooooo`;o0000;_ooool00ol0003ooooo
ooooo`3Aooooo`005Oooool2o`0002gooooo00?o0000ooooooooool0d_ooool001Gooooo00?o0000
ooooool00000:oooool00ol0003oooooooooo`3Cooooo`005Oooool00ol0003oooooo`00000Zoooo
o`03o`000?oooooooooo0=Cooooo000Eooooo`03o`000?oooooo000002Wooooo00?o0000oooooooo
ool0eOooool001Gooooo0_l000000ooooooo0000ooooo`0Vooooo`03o`000?oooooooooo0=Kooooo
000Eooooo`04o`000?ooooooooooo`0002Gooooo0_l0003Iooooo`005Oooool01?l0003ooooooooo
ool0000Tooooo`03o`000?oooooooooo0=Wooooo000Eooooo`05o`000?ooooooooooooooool00000
8_ooool00ol0003oooooooooo`3Jooooo`005Oooool01Ol0003ooooooooooooooooo0000027ooooo
00?o0000ooooooooool0foooool001Gooooo00Go0000ooooooooooooooooo`00000Pooooo`03o`00
0?oooooooooo0=cooooo000Eooooo`;o00000oooool00ol0003oooooooooo`0Looooo`03o`000?oo
oooooooo0=gooooo000Eooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool06oooool0
0ol0003oooooooooo`3Nooooo`005Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
01Wooooo00?o0000ooooooooool0goooool001Gooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`0Hooooo`03o`000?oooooooooo0>3ooooo000Eooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool05Oooool2o`000>?ooooo000Eooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool04oooool00ol0003oooooooooo`3Sooooo`005Oooool2o`0000Kooooo00?o0000
ooooooooool04Oooool2o`000>Kooooo000Eooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`3Vooooo`005Oooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo00gooooo0_l0003Yooooo`005Oooool00ol0003oooooooooo`07ooooo`;o0000
2oooool2o`000>_ooooo0002ooooo`?o00000oooool00ol0003oooooooooo`02ooooo`?o00001Ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0jooo
ool000?ooooo00?o0000ooooooooool01_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool02_ooool9o`000>kooooo0005o`0000_ooooo00?o0000ooooooooool00_ooool2
o`0000oooooo00?o0000ooooooooool0l?ooool00004o`000?ooooooooooo`0000cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`3oooooo`;ooooo00001?oooooo0000ooooool00008
ooooo`Co00001Oooool00ol0003oooooooooo`3oooooo`;ooooo0002ooooo`;o00002?ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo0?oooooo0_ooool000?ooooo00?o0000oooooooo
ool01_ooool5o`000?oooooo2Oooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool0
0?oooooo6_ooool00001\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-0.0842314, 1.70844, \
0.0039501, 0.0169324}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FindRoot", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["s1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", "0"}], 
        ",", \({t, 0}\)}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({t \[Rule] 0.06705991301808452`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s1[t /. %]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(4.4886680287113805`\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 6.5 M", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[DoublePrime]",
                    MultilineFunction->None], "[", "t", "]"}], "+", 
                RowBox[{"6", " ", 
                  RowBox[{
                    SuperscriptBox["x", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], 
                "+", \(9\ x[t]\)}], "==", "0"}], ",", \(x[0] == \(-2\)\), ",",
             
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", "15"}]}], 
          "}"}], ",", \(x[t]\), ",", "t"}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{x[
            t] \[Rule] \[ExponentialE]\^\(\(-3\)\ t\)\ \((\(-2\) + 
                9\ t)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s2[t_] = x[t] /. %\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(\(-3\)\ t\)\ \((\(-2\) + 9\ t)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[s2[t], {t, 0, 3}, PlotRange \[Rule] {\(-2\), 1}]\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.412023 0.206011 [
[.18254 .39952 -9 -9 ]
[.18254 .39952 9 0 ]
[.34127 .39952 -3 -9 ]
[.34127 .39952 3 0 ]
[.5 .39952 -9 -9 ]
[.5 .39952 9 0 ]
[.65873 .39952 -3 -9 ]
[.65873 .39952 3 0 ]
[.81746 .39952 -9 -9 ]
[.81746 .39952 9 0 ]
[.97619 .39952 -3 -9 ]
[.97619 .39952 3 0 ]
[.01131 0 -12 -4.5 ]
[.01131 0 0 4.5 ]
[.01131 .10301 -24 -4.5 ]
[.01131 .10301 0 4.5 ]
[.01131 .20601 -12 -4.5 ]
[.01131 .20601 0 4.5 ]
[.01131 .30902 -24 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .51503 -18 -4.5 ]
[.01131 .51503 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .41202 m
.18254 .41827 L
s
[(0.5)] .18254 .39952 0 1 Mshowa
.34127 .41202 m
.34127 .41827 L
s
[(1)] .34127 .39952 0 1 Mshowa
.5 .41202 m
.5 .41827 L
s
[(1.5)] .5 .39952 0 1 Mshowa
.65873 .41202 m
.65873 .41827 L
s
[(2)] .65873 .39952 0 1 Mshowa
.81746 .41202 m
.81746 .41827 L
s
[(2.5)] .81746 .39952 0 1 Mshowa
.97619 .41202 m
.97619 .41827 L
s
[(3)] .97619 .39952 0 1 Mshowa
.125 Mabswid
.05556 .41202 m
.05556 .41577 L
s
.0873 .41202 m
.0873 .41577 L
s
.11905 .41202 m
.11905 .41577 L
s
.15079 .41202 m
.15079 .41577 L
s
.21429 .41202 m
.21429 .41577 L
s
.24603 .41202 m
.24603 .41577 L
s
.27778 .41202 m
.27778 .41577 L
s
.30952 .41202 m
.30952 .41577 L
s
.37302 .41202 m
.37302 .41577 L
s
.40476 .41202 m
.40476 .41577 L
s
.43651 .41202 m
.43651 .41577 L
s
.46825 .41202 m
.46825 .41577 L
s
.53175 .41202 m
.53175 .41577 L
s
.56349 .41202 m
.56349 .41577 L
s
.59524 .41202 m
.59524 .41577 L
s
.62698 .41202 m
.62698 .41577 L
s
.69048 .41202 m
.69048 .41577 L
s
.72222 .41202 m
.72222 .41577 L
s
.75397 .41202 m
.75397 .41577 L
s
.78571 .41202 m
.78571 .41577 L
s
.84921 .41202 m
.84921 .41577 L
s
.88095 .41202 m
.88095 .41577 L
s
.9127 .41202 m
.9127 .41577 L
s
.94444 .41202 m
.94444 .41577 L
s
.25 Mabswid
0 .41202 m
1 .41202 L
s
.02381 0 m
.03006 0 L
s
[(-2)] .01131 0 1 0 Mshowa
.02381 .10301 m
.03006 .10301 L
s
[(-1.5)] .01131 .10301 1 0 Mshowa
.02381 .20601 m
.03006 .20601 L
s
[(-1)] .01131 .20601 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(-0.5)] .01131 .30902 1 0 Mshowa
.02381 .51503 m
.03006 .51503 L
s
[(0.5)] .01131 .51503 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0206 m
.02756 .0206 L
s
.02381 .0412 m
.02756 .0412 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .0824 m
.02756 .0824 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .14421 m
.02756 .14421 L
s
.02381 .16481 m
.02756 .16481 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26781 m
.02756 .26781 L
s
.02381 .28842 m
.02756 .28842 L
s
.02381 .32962 m
.02756 .32962 L
s
.02381 .35022 m
.02756 .35022 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .45322 m
.02756 .45322 L
s
.02381 .47383 m
.02756 .47383 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .53563 m
.02756 .53563 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57683 m
.02756 .57683 L
s
.02381 .59743 m
.02756 .59743 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 0 m
.04262 .15905 L
.06244 .28265 L
.08255 .37246 L
.09396 .41082 L
.10458 .43986 L
.11508 .4631 L
.125 .4808 L
.13384 .49354 L
.14357 .50471 L
.15327 .51326 L
.15822 .51675 L
.16355 .51992 L
.16852 .52236 L
.17307 .5242 L
.17775 .52573 L
.18199 .52682 L
.18675 .52773 L
.18937 .5281 L
.19183 .52837 L
.19294 .52847 L
.19412 .52856 L
.19513 .52862 L
.19622 .52867 L
.19739 .52871 L
.19849 .52874 L
.19979 .52875 L
.20097 .52875 L
.20226 .52873 L
.2029 .52872 L
.20362 .52869 L
.20488 .52864 L
.20607 .52858 L
.20874 .52839 L
.21161 .52812 L
.21687 .52745 L
.2217 .52664 L
.2315 .52455 L
.24062 .52212 L
.26132 .51537 L
.30036 .50019 L
.34186 .48359 L
.38184 .46899 L
.42031 .45693 L
.46123 .44636 L
.50063 .43823 L
.53852 .43205 L
.57886 .42694 L
.61768 .42319 L
.65896 .42018 L
Mistroke
.69872 .41802 L
.73697 .41646 L
.77766 .41524 L
.81685 .41437 L
.85848 .4137 L
.8986 .41323 L
.9372 .4129 L
.97619 .41266 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{17, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`004_ooool5o`000?oooooo0ooo
ool001?ooooo00Co0000oooooooooooo0000ooooool3ooooo`003?ooool5o`0000?ooooo00?o0000
ooooooooool0ooooool3ooooo`005Oooool00ol0003oooooooooo`03ooooo`;o0000o?ooool001;o
oooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo0?_ooooo000Booooo`05
o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`3kooooo`004oooool3o`0000Go
oooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo0_l0
003looooo`006oooool2o`000?cooooo000Kooooo`;o0000o?ooool001_ooooo0_l0003looooo`00
6oooool2o`000?cooooo000Kooooo`;o0000o?ooool001_ooooo0_l0003looooo`006oooool2o`00
0?cooooo000Kooooo`03o`000?oooooo00000?_ooooo000Kooooo`03o`000?oooooo00000?_ooooo
000Kooooo`03o`000?oooooo00000?_ooooo000Kooooo`?o0000noooool001_ooooo00?o0000oooo
ool00000noooool001_ooooo00?o0000ooooool00000noooool001_ooooo00?o0000ooooool00000
noooool001_ooooo00?o0000ooooool00000noooool001_ooooo0_l000000ooooooo0000ooooo`3i
ooooo`006oooool01?l0003oooooooooool0003jooooo`006oooool01?l0003oooooooooool0003j
ooooo`001oooool3o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00Co0000oooo
oooooooo0000n_ooool000Sooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo
000000Cooooo00Co0000oooooooooooo0000n_ooool000Go00000oooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00;ooooo0_l000000ooooooo0000ooooo`3iooooo`002?ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000n_ooool0
00Sooooo00?o0000ooooooooool01oooool4o`0000Gooooo00Co0000oooooooooooo0000n_ooool0
00Oooooo0_l00009ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo0000n_ooool0
00Sooooo00?o0000ooooooooool01oooool5o`0000Cooooo00Go0000ooooooooooooooooo`00003i
ooooo`006oooool01Ol0003ooooooooooooooooo00000?Wooooo000Kooooo`;o00000_ooool00ol0
003oooooooooo`3gooooo`006oooool01Ol0003ooooooooooooooooo00000?Wooooo000Kooooo`05
o`000?ooooooooooooooool00000nOooool001_ooooo00Go0000ooooooooooooooooo`00003ioooo
o`006oooool01Ol0003ooooooooooooooooo00000?Wooooo000Kooooo`;o00000_ooool00ol0003o
ooooooooo`3gooooo`006oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?Kooooo
000Kooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0m_ooool001_ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`3fooooo`006oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo0?Kooooo000Kooooo`;o00000oooool00ol0003oooooooooo`3fooooo`00
6oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?Kooooo000Kooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool0m_ooool001_ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`3eooooo`006oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
0?Gooooo000Kooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0mOooool001_ooooo
0_l00004ooooo`03o`000?oooooooooo0?Gooooo000Kooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool0mOooool001_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`3e
ooooo`004oooool3o`0000Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`3eoooo
o`005?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0m?ooool000cooooo1Ol00003ooooo`03o`000?oooooooooo00Cooooo0_l00005ooooo`03o`00
0?oooooooooo0?Cooooo000Dooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`3dooooo`005?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool0m?ooool001?ooooo0_l00006ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool0m?ooool001Cooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo0?Cooooo000Kooooo`;o00001_ooool00ol0003ooooo
ooooo`3cooooo`006oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo0??ooooo000K
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0loooool001_ooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`3cooooo`006oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo0??ooooo000Kooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
loooool001_ooooo0_l00007ooooo`03o`000?oooooooooo0?;ooooo000Kooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool0l_ooool001_ooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`3booooo`006oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?;o
oooo000Kooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0l_ooool001_ooooo0_l0
0007ooooo`03o`000?oooooooooo0?;ooooo000Kooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool0l_ooool001_ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`3aoooo
o`006oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo0?7ooooo000Kooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool0lOooool001_ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`3aooooo`006oooool2o`0000Sooooo00?o0000ooooooooool0lOooool0
01_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`3`ooooo`002?ooool2o`0000Co
oooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`3`ooooo`001oooool01?l0003oooooooooool00007ooooo`05o`000?oooooooooooooo
ool000001?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0?3ooooo0005o`0000;o
oooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool0l?ooool000Oooooo00Co0000oooooooooooo00002oooool00ol0
003oooooooooo`02ooooo`;o00002Oooool00ol0003oooooooooo`3`ooooo`001oooool01?l0003o
ooooooooool00007ooooo`Co00001Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
0>oooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo0>oooooo0008ooooo`;o00002?ooool5o`0000Co
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`3_ooooo`006oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo0>oooooo000Kooooo`;o00002oooool00ol0003ooooooooo
o`3^ooooo`006oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo0>kooooo000Koooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0k_ooool001_ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`3^ooooo`006oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo0>kooooo000Kooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0kOoo
ool001_ooooo0_l0000<ooooo`03o`000?oooooooooo0>gooooo000Kooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool0kOooool001_ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`3]ooooo`006oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo0>gooooo
000Kooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool04?ooool2o`0000Cooooo00?o
0000ooooooooool00_ooool3o`00023ooooo0ol0000Pooooo`?o00001?ooool00ol0003ooooooooo
o`02ooooo`?o00008?ooool5o`0001kooooo1Ol00003ooooo`03o`000?oooooooooo00;ooooo0ol0
000Pooooo`?o00001_ooool001_ooooo0_l0000=ooooo`03o`000?oooooooooo00oooooo00Co0000
oooooooooooo00001oooool01Ol0003ooooooooooooooooo0000023ooooo00?o0000ooooooooool0
8?ooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool000008?ooool01?l0003o
ooooooooool0000Oooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00
000Nooooo`05o`000?ooooooooooooooool000001Oooool001_ooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0?ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool0
7_ooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
7oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
8?ooool00ol0003oooooooooo`03ooooo`006oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo00oooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`0Nooooo`03o`00
0?oooooooooo023ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Pooooo`03o`00
0?oooooooooo023ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Nooooo`;o0000
1_ooool001_ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0>ooooo`04o`000?oo
ooooooooo`0000Oooooo1?l0000Qooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0
1oooool4o`00023ooooo00Go0000ooooooooooooooooo`00000Nooooo`05o`000?oooooooooooooo
ool000001oooool4o`0002?ooooo00?o0000ooooooooool00oooool001_ooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000oooo
ooooool08Oooool2o`00027ooooo0_l00009ooooo`03o`000?oooooooooo027ooooo00Go0000oooo
ooooooooooooo`00000Nooooo`05o`000?ooooooooooooooool000001oooool00ol0003ooooooooo
o`0Pooooo`05o`000?ooooooooooooooool000001Oooool001_ooooo0_l0000>ooooo`03o`000?oo
oooooooo00oooooo0_l00008ooooo`Go00008?ooool00ol0003oooooooooo`0Pooooo`03o`000?oo
oooooooo00Oooooo1Ol0000Pooooo`?o00008?ooool3o`0000Sooooo1Ol0000Oooooo`?o00001_oo
ool001_ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`3Zooooo`006oooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo0>[ooooo000Kooooo`03o`000?oooooooooo00ko
oooo00?o0000ooooooooool0j_ooool001_ooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`3Yooooo`006oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo0>Wooooo000E
oooooooo00001Ol0000001_ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05oooo
o`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00;ooooo5Ol00007ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo000Koooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool0R_ooool:o`0005Cooooo000Kooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool0Ooooool;o`0005kooooo000Kooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool0M?ooool:o`0006Wooooo000Kooooo`;o00004_oo
ool00ol0003oooooooooo`1Zooooo`[o0000Loooool001_ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`1Sooooo`Oo0000OOooool001_ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`1Nooooo`Co0000Q?ooool001_ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`1Kooooo`?o0000R?ooool001_ooooo00?o0000ooooooooool04oooool00ol0003ooooo
ooooo`1Fooooo`Co0000Roooool001_ooooo0_l0000Dooooo`03o`000?oooooooooo057ooooo1Ol0
002?ooooo`006oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo04cooooo1Ol0002D
ooooo`006oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo04Sooooo0ol0002Ioooo
o`006oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo04Gooooo0ol0002Looooo`00
6oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo04;ooooo0ol0002Oooooo`006ooo
ool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo03kooooo0ol0002Rooooo`006oooool2
o`0001Oooooo00?o0000ooooooooool0>_ooool3o`000:Gooooo000Kooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool0=oooool3o`000:Sooooo000Kooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool0=?ooool2o`000:_ooooo000Kooooo`03o`000?oooooooooo01Oooooo
00?o0000ooooooooool0<_ooool2o`000:gooooo000Kooooo`03o`000?oooooooooo01Sooooo00?o
0000ooooooooool0;oooool2o`000:oooooo000Kooooo`;o00006_ooool00ol0003oooooooooo`0/
ooooo`;o0000/Oooool001_ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0Yoooo
o`;o0000/oooool001_ooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0Vooooo`;o
0000]Oooool000Sooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`00
0?oooooooooo01cooooo00?o0000ooooooooool08_ooool3o`000;Oooooo0007ooooo`04o`000?oo
ooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo01go
oooo00?o0000ooooooooool07_ooool3o`000;[ooooo0007ooooo`04o`000?ooooooooooo`0000_o
oooo00?o0000ooooooooool00_ooool2o`0001oooooo0_l0000Kooooo`?o0000_Oooool000Oooooo
00Co0000oooooooooooo00002oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo023o
oooo00?o0000ooooooooool05Oooool3o`000<3ooooo0007ooooo`04o`000?ooooooooooo`0000Oo
oooo1?l00005ooooo`03o`000?oooooooooo027ooooo0ol0000@ooooo`Co0000`oooool000Oooooo
00Co0000oooooooooooo00001oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo02Co
oooo0ol00009ooooo`Co0000aoooool000Sooooo0_l00008ooooo`Go00001?ooool00ol0003ooooo
ooooo`0Wooooo`Wo0000boooool001_ooooo00?o0000ooooooooool0noooool001_ooooo0_l0003l
ooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`00
6oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool2
o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_o
oooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000K
ooooo`;o0000o?ooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000oooooooo
ool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0nooo
ool001_ooooo00?o0000ooooooooool0noooool001_ooooo0_l0003looooo`006oooool00ol0003o
ooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`004oooool3o`0000Gooooo00?o
0000ooooooooool0noooool001Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3k
ooooo`005?ooool00ol0003oooooooooo`04ooooo`;o0000o?ooool001Cooooo00?o0000oooooooo
ool0ooooool3ooooo`005?ooool00ol0003oooooooooo`3oooooo`?ooooo000Cooooo`;o0000oooo
ool5ooooo`005?ooool00ol0003oooooooooo`3oooooo`?ooooo003ooooooa[ooooo003ooooooa[o
oooo0000\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-0.330441, -2.11826, \
0.0121272, 0.0186878}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        SuperscriptBox["s2", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(-3\)\ \[ExponentialE]\^\(\(-3\)\ t\)\ \((\(-5\) + 9\ t)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Exp[3\ t]\ % == 0, t]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{t \[Rule] 5\/9}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s2[t /. %\[LeftDoubleBracket]1\[RightDoubleBracket]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(3\/\[ExponentialE]\^\(5/3\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0.5666268085126855`\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 6.6 M", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"soln", "=", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    SuperscriptBox["x", "\[DoublePrime]",
                      MultilineFunction->None], "[", "t", "]"}], "+", 
                  RowBox[{"2", " ", 
                    RowBox[{
                      SuperscriptBox["x", "\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}]}], 
                  "+", \(40\ x[t]\)}], "==", "0"}], 
              ",", \(x[0] == \(-\(1\/2\)\)\), ",", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "[", "0", "]"}], 
                "==", \(-1\)}]}], "}"}], ",", \(x[t]\), ",", "t"}], 
        "]"}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{x[
            t] \[Rule] \(-\(1\/26\)\)\ \[ExponentialE]\^\(-t\)\ \((13\ \
Cos[\@39\ t] + \@39\ Sin[\@39\ t])\)}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s2[t_] = 
      Simplify[ComplexExpand[
          x[t] /. soln\[LeftDoubleBracket]1\[RightDoubleBracket]]]\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-\(1\/26\)\)\ \[ExponentialE]\^\(-t\)\ \((13\ Cos[\@39\ t] + \@39\ \
Sin[\@39\ t])\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p1 = Plot[s2[t], {t, 0, 3}, PlotRange \[Rule] {\(-1\), 1}]\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.309017 0.309017 [
[.18254 .29652 -9 -9 ]
[.18254 .29652 9 0 ]
[.34127 .29652 -3 -9 ]
[.34127 .29652 3 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 0 -12 -4.5 ]
[.01131 0 0 4.5 ]
[.01131 .07725 -30 -4.5 ]
[.01131 .07725 0 4.5 ]
[.01131 .15451 -24 -4.5 ]
[.01131 .15451 0 4.5 ]
[.01131 .23176 -30 -4.5 ]
[.01131 .23176 0 4.5 ]
[.01131 .38627 -24 -4.5 ]
[.01131 .38627 0 4.5 ]
[.01131 .46353 -18 -4.5 ]
[.01131 .46353 0 4.5 ]
[.01131 .54078 -24 -4.5 ]
[.01131 .54078 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .30902 m
.18254 .31527 L
s
[(0.5)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(1)] .34127 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(2)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 0 m
.03006 0 L
s
[(-1)] .01131 0 1 0 Mshowa
.02381 .07725 m
.03006 .07725 L
s
[(-0.75)] .01131 .07725 1 0 Mshowa
.02381 .15451 m
.03006 .15451 L
s
[(-0.5)] .01131 .15451 1 0 Mshowa
.02381 .23176 m
.03006 .23176 L
s
[(-0.25)] .01131 .23176 1 0 Mshowa
.02381 .38627 m
.03006 .38627 L
s
[(0.25)] .01131 .38627 1 0 Mshowa
.02381 .46353 m
.03006 .46353 L
s
[(0.5)] .01131 .46353 1 0 Mshowa
.02381 .54078 m
.03006 .54078 L
s
[(0.75)] .01131 .54078 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .01545 m
.02756 .01545 L
s
.02381 .0309 m
.02756 .0309 L
s
.02381 .04635 m
.02756 .04635 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .10816 m
.02756 .10816 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .13906 m
.02756 .13906 L
s
.02381 .16996 m
.02756 .16996 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .20086 m
.02756 .20086 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26266 m
.02756 .26266 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .29357 m
.02756 .29357 L
s
.02381 .32447 m
.02756 .32447 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .35537 m
.02756 .35537 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .41717 m
.02756 .41717 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .44807 m
.02756 .44807 L
s
.02381 .47898 m
.02756 .47898 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .50988 m
.02756 .50988 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57168 m
.02756 .57168 L
s
.02381 .58713 m
.02756 .58713 L
s
.02381 .60258 m
.02756 .60258 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .15451 m
.02605 .15249 L
.02846 .15071 L
.03072 .14939 L
.03279 .14848 L
.03405 .14806 L
.03521 .14777 L
.03649 .14755 L
.03713 .14748 L
.03784 .14743 L
.03903 .14743 L
.04031 .14752 L
.04151 .14771 L
.04262 .14795 L
.04384 .14832 L
.04514 .14881 L
.04748 .14994 L
.05026 .15172 L
.05278 .15372 L
.06244 .16458 L
.06787 .17272 L
.07287 .18136 L
.08414 .20425 L
.10458 .25364 L
.125 .30553 L
.14407 .34893 L
.15348 .36683 L
.16239 .38102 L
.16732 .38759 L
.17267 .39367 L
.17718 .3979 L
.18204 .40153 L
.18457 .40304 L
.18689 .4042 L
.18924 .40515 L
.19144 .40583 L
.19261 .40612 L
.19385 .40636 L
.19456 .40647 L
.19524 .40656 L
.19649 .40668 L
.19714 .40671 L
.19782 .40673 L
.19905 .40672 L
.20036 .40664 L
.20111 .40657 L
.20181 .40648 L
.20311 .40627 L
.20453 .40597 L
.20711 .40523 L
Mistroke
.20961 .40428 L
.21194 .4032 L
.21721 .40008 L
.22282 .39579 L
.23313 .38558 L
.24427 .37179 L
.26446 .34223 L
.28404 .31211 L
.30551 .28275 L
.31539 .27177 L
.32597 .2623 L
.3311 .25864 L
.33596 .25575 L
.34065 .25352 L
.34505 .25191 L
.34727 .25128 L
.34965 .25074 L
.35095 .25051 L
.3523 .2503 L
.35346 .25016 L
.35473 .25005 L
.35543 .25 L
.35608 .24997 L
.35731 .24993 L
.35863 .24994 L
.35937 .24996 L
.36005 .24998 L
.3612 .25006 L
.36246 .25017 L
.36377 .25033 L
.365 .25051 L
.36739 .25096 L
.36965 .2515 L
.37389 .2528 L
.37846 .25461 L
.38343 .25702 L
.40318 .27042 L
.42418 .28896 L
.4619 .32243 L
.47131 .32914 L
.48122 .33504 L
.48641 .33761 L
.4921 .33998 L
.49688 .34161 L
.50207 .34299 L
.50481 .34356 L
.50735 .34399 L
.50977 .3443 L
.511 .34443 L
.51233 .34455 L
Mistroke
.51353 .34463 L
.51462 .34468 L
.51572 .34472 L
.51677 .34474 L
.51798 .34474 L
.51911 .34473 L
.52034 .34469 L
.52166 .34463 L
.52307 .34454 L
.52438 .34443 L
.52732 .34409 L
.52991 .3437 L
.53264 .3432 L
.5426 .34062 L
.55209 .33719 L
.56225 .33266 L
.58059 .323 L
.60042 .31181 L
.62197 .30074 L
.63202 .29645 L
.64269 .29273 L
.65179 .2903 L
.65697 .28924 L
.66184 .28846 L
.66654 .28792 L
.6692 .2877 L
.67168 .28755 L
.67303 .28749 L
.6743 .28745 L
.67545 .28743 L
.67669 .28741 L
.67733 .28741 L
.67804 .28741 L
.67878 .28742 L
.67947 .28743 L
.68071 .28746 L
.6814 .28748 L
.68204 .28751 L
.6844 .28762 L
.68658 .28777 L
.69153 .28825 L
.6959 .28882 L
.70055 .28958 L
.71087 .29176 L
.72201 .29474 L
.7422 .30121 L
.7618 .30789 L
.78328 .31446 L
.79317 .31695 L
.80375 .31912 L
Mistroke
.80889 .31996 L
.81374 .32063 L
.81844 .32116 L
.82283 .32155 L
.82524 .32171 L
.82744 .32184 L
.82989 .32195 L
.83124 .32199 L
.83252 .32203 L
.83376 .32205 L
.83507 .32207 L
.83631 .32208 L
.83744 .32208 L
.83813 .32208 L
.83876 .32207 L
.83946 .32207 L
.8402 .32205 L
.84144 .32203 L
.8428 .32199 L
.84521 .32191 L
.8474 .32181 L
.85233 .3215 L
.8569 .32111 L
.86124 .32066 L
.88114 .31775 L
.89955 .31422 L
.9198 .31004 L
.93881 .30643 L
.95679 .3037 L
.96691 .30256 L
.97619 .3018 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{17, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJ
ooooo`006Oooool3o`000?gooooo000Jooooo`03o`000?oooooooooo0?cooooo000Booooo`Go0000
0oooool00ol0003oooooooooo`3looooo`006_ooool00ol0003oooooooooo`04ooooo`;o0000m_oo
ool001[ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3eooooo`006Oooool2o`00
00Kooooo00?o0000ooooooooool0mOooool001[ooooo00?o0000ooooooooool01?ooool2o`000?Ko
oooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Q
ooooo`03o`000?oooooooooo0?Gooooo000Qooooo`;o0000m_ooool0027ooooo00?o0000oooooooo
ool0mOooool0027ooooo00?o0000ooooooooool0mOooool0027ooooo00?o0000ooooooooool0mOoo
ool0027ooooo0_l0003fooooo`008Oooool00ol0003oooooooooo`3eooooo`008Oooool00ol0003o
ooooooooo`3eooooo`008Oooool00ol0003oooooooooo`3eooooo`008Oooool2o`000?Kooooo000Q
ooooo`03o`000?oooooooooo0?Gooooo0008ooooo`;o00001?ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`000?oooooooooo0?Gooooo0007ooooo`04
o`000?ooooooooooo`0000Wooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0mOooool000Go00000_ooool01?l0003oooooooooool0000:
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool2o`000?Kooooo0007oooo
o`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo0?Gooooo0007ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000
ooooool000000ol00005ooooo`03o`000?oooooooooo0?Gooooo0007ooooo`04o`000?oooooooooo
o`0000Oooooo00Oo0000ooooooooooooooooo`000?oooooo000000Sooooo00?o0000ooooooooool0
mOooool000Sooooo0_l00008ooooo`Go000000?oooooo`000?l000000ol00004ooooo`;o0000m_oo
ool0027ooooo00?o0000ooooooooool0mOooool0027ooooo00?o0000ooooooooool0mOooool0027o
oooo00?o0000ooooooooool0mOooool0027ooooo0_l0003fooooo`008Oooool00ol0003ooooooooo
o`3eooooo`008Oooool00ol0003oooooooooo`3eooooo`008Oooool00ol0003oooooooooo`3eoooo
o`008Oooool2o`000?Kooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`03o`000?oo
oooooooo0?Gooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`;o0000m_ooool000ko
oooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`000?oooooooooo0?Go
oooo000=ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004oooo
o`Ko0000l_ooool000Kooooo1Ol00002ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000oooo
ooooool00_ooool2o`0000Cooooo00?o0000ooooooooool0koooool000gooooo00Co0000oooooooo
oooo00002oooool00ol0003oooooooooo`02ooooo`;o00001Oooool00ol0003oooooooooo`3^oooo
o`003Oooool01?l0003oooooooooool00007ooooo`Co00001Oooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo0>gooooo000=ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0>cooooo000>ooooo`;o
00002?ooool5o`0000Cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`3[ooooo`00
8Oooool2o`0000Wooooo00?o0000ooooooooool0j_ooool0027ooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`3Zooooo`008Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo0>Wooooo000Qooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0jOooool0027o
oooo0_l0000:ooooo`03o`000?oooooooooo0>Wooooo000Qooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool0j?ooool0027ooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`3Wooooo`008Oooool2o`0000cooooo00?o0000ooooooooool0ioooool0027ooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`3Vooooo`008Oooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo0>Kooooo000Qooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0
iOooool0027ooooo0_l0000>ooooo`03o`000?oooooooooo0>Gooooo000Qooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool0iOooool000Sooooo0_l00004ooooo`04o`000?oooooooooo
ooooo`Go00000_ooool3o`0000Gooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`3T
ooooo`001oooool01?l0003oooooooooool00008ooooo`06o`000?ooooooooooo`000?oooooo0000
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0
i?ooool000Go00000_ooool01?l0003oooooooooool00009ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool00_ooool2o`00013ooooo00?o0000ooooooooool0hoooool000Oooooo00Co
0000oooooooooooo00002_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`3Sooooo`001oooool01?l0003ooooooooo
ool00007ooooo`06o`000?ooooooooooooooool0003ooooo1?l00005ooooo`03o`000?oooooooooo
00oooooo00?o0000ooooooooool0hoooool000Oooooo00Co0000oooooooooooo00001oooool01ol0
003ooooooooooooooooo0000ooooool000002?ooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo0>;ooooo0008ooooo`;o00002Oooool3o`0000;ooooo1Ol00004ooooo`;o00004Oooool0
0ol0003oooooooooo`3Rooooo`008Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
03_ooooo1ol0002Pooooo`008Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo03So
oooo0_l00007ooooo`?o0000WOooool0027ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0fooooo`;o00003?ooool2o`0009_ooooo000Qooooo`;o00004oooool00ol0003ooooooooo
o`0dooooo`03o`000?oooooooooo00kooooo0_l0002Iooooo`008Oooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo00Wooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000L
ooooo`03o`000?oooooooooo00?o00003_ooool00ol0003oooooooooo`0>ooooo`?o00001?ooool0
0ol0003oooooooooo`02ooooo`?o00007oooool5o`0001gooooo1Ol00003ooooo`03o`000?oooooo
oooo00;ooooo0ol0000Oooooo`?o00001_ooool0027ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`08ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00
000Jooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00000Oooooo`04o`00
0?ooooooooooo`0001kooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo
000001gooooo00Go0000ooooooooooooooooo`000005ooooo`008Oooool00ol0003oooooooooo`0C
ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo00002oooool00ol0003ooooooooo
o`0Gooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03oooool00ol0003ooooooooo
o`0=ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool07_ooool00ol0003ooooooooo
o`0Oooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool07oooool00ol0003ooooooooo
o`03ooooo`008Oooool2o`0001Cooooo00?o0000ooooooooool01oooool01?l0003oooooooooool0
000;ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0@ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0Oooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0Mooooo`;o00001_ooool0027ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`06
ooooo`04o`000?ooooooooooo`0000Oooooo1?l0000Hooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Oooooo1?l0
000Oooooo`05o`000?ooooooooooooooool000007Oooool01Ol0003ooooooooooooooooo000000Oo
oooo1?l0000Rooooo`03o`000?oooooooooo00?ooooo000Qooooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool01_ooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo01Wo
oooo00?o0000ooooooooool01?ooool2o`0001Cooooo00?o0000ooooooooool02Oooool2o`0000Wo
oooo00?o0000ooooooooool08?ooool01?l0003oooooooooooooool6o`0001Sooooo00Go0000oooo
ooooooooooooo`000007ooooo`03o`000?oooooooooo01oooooo00Go0000ooooooooooooooooo`00
0005ooooo`008Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00Oooooo0_l00008
ooooo`Go00005_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01?ooooo0_l0000:
ooooo`03o`000?oooooooooo00Oooooo1Ol0000Nooooo`Ko00001?ooool6o`0001?ooooo0ol00008
ooooo`Go00007_ooool3o`0000Kooooo000Qooooo`;o00005_ooool00ol0003oooooooooo`0Zoooo
o`03o`000?oooooooooo01oooooo00?o0000ooooooooool0<_ooool2o`00013ooooo1Ol00015oooo
o`008Oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo02[ooooo00?o0000oooooooo
ool08?ooool00ol0003oooooooooo`0^ooooo`?o00005oooool3o`0004;ooooo000Qooooo`03o`00
0?oooooooooo01Gooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`0Rooooo`03o`00
0?oooooooooo02[ooooo0ol0000Mooooo`;o0000=_ooool4o`0000Kooooo000Qooooo`03o`000?oo
oooooooo01Kooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0Sooooo`;o0000:?oo
ool2o`0002;ooooo0ol0000[ooooo`So00002_ooool001_oooooo_l00000027ooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ool000001Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo000000Gooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo0_l00006
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool4o`0000Kooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Ko00001oooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo000Qooooo`03o`000?oooooooooo
01Oooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo
01gooooo0ol0000booooo`Co00004?ooool5o`0001cooooo000Qooooo`03o`000?oooooooooo01So
oooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo01[o
oooo0_l0000ioooooa3o00008Oooool0027ooooo0_l0000Iooooo`03o`000?oooooooooo02;ooooo
00?o0000ooooooooool0;Oooool00ol0003oooooooooo`0Gooooo`;o0000K?ooool0027ooooo00?o
0000ooooooooool06Oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo02oooooo0_l0
000Fooooo`03o`000?oooooooooo06cooooo000Qooooo`03o`000?oooooooooo01Wooooo00?o0000
ooooooooool08?ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo017ooooo0_l0001_
ooooo`008Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo01oooooo00?o0000oooo
ooooool0<oooool2o`0000oooooo0_l0001aooooo`008Oooool2o`0001_ooooo00?o0000oooooooo
ool07Oooool00ol0003oooooooooo`0fooooo`?o00002Oooool3o`0007?ooooo000Qooooo`03o`00
0?oooooooooo01[ooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`0iooooo`Wo0000
M_ooool0027ooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0Kooooo`03o`000?oo
oooooooo0;Wooooo000Qooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool06_ooool0
0ol0003oooooooooo`2jooooo`008Oooool2o`0001gooooo00?o0000ooooooooool06Oooool00ol0
003oooooooooo`2jooooo`008Oooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool0^oooool0027ooooo00?o0000ooooooooool07Oooool00ol0003ooooo
ooooo`0Gooooo`03o`000?oooooooooo0;_ooooo000Qooooo`03o`000?oooooooooo01kooooo00?o
0000ooooooooool05Oooool00ol0003oooooooooo`2looooo`008Oooool2o`0001oooooo00?o0000
ooooooooool05?ooool00ol0003oooooooooo`2mooooo`002?ooool2o`0000Cooooo00Co0000oooo
oooooooooooo1Ol00002ooooo`?o00001Oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool0__ooool000Oooooo00Co0000oooooooooooo00002?ooool0
1_l0003oooooooooool0003oooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`0Pooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0_oooool000Oooooo00Co
0000oooooooooooo00002Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool08?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo0<3ooooo
0007ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`02ooooo`;o00008_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo0<7ooooo
0007ooooo`04o`000?ooooooooooo`0000Oooooo00Ko0000ooooooooooooooooo`000?ooool4o`00
00Gooooo00?o0000ooooooooool08_ooool2o`0000cooooo00?o0000ooooooooool0`_ooool000Oo
oooo00Co0000oooooooooooo00001oooool01ol0003ooooooooooooooooo0000ooooool000002?oo
ool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0`ooo
ool000Sooooo0_l00009ooooo`?o00000_ooool5o`0000Cooooo0_l0000Vooooo`03o`000?oooooo
oooo00Gooooo0_l00036ooooo`008Oooool00ol0003oooooooooo`0Uooooo`?o00000oooool2o`00
0<Sooooo000Qooooo`03o`000?oooooooooo02Oooooo1?l0003:ooooo`008Oooool00ol0003ooooo
ooooo`3eooooo`008Oooool2o`000?Kooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qoooo
o`03o`000?oooooooooo0?Gooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`;o0000
m_ooool0027ooooo00?o0000ooooooooool0mOooool0027ooooo00?o0000ooooooooool0mOooool0
027ooooo00?o0000ooooooooool0mOooool0027ooooo0_l0003fooooo`008Oooool00ol0003ooooo
ooooo`3eooooo`003_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o
0000ooooooooool0mOooool000gooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooo
oooooooo000000Cooooo00?o0000ooooooooool0mOooool000gooooo00Co0000oooooooooooo0000
2oooool00ol0003oooooooooo`02ooooo`;o0000m_ooool000gooooo00Co0000oooooooooooo0000
2oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?Gooooo000=ooooo`04o`000?oo
ooooooooo`0000Oooooo1?l00005ooooo`03o`000?oooooooooo0?Gooooo000=ooooo`04o`000?oo
ooooooooo`0000Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`3eooooo`003_oo
ool2o`0000Sooooo1Ol00004ooooo`;o0000m_ooool0027ooooo00?o0000ooooooooool0mOooool0
027ooooo00?o0000ooooooooool0mOooool0027ooooo00?o0000ooooooooool0mOooool0027ooooo
0_l0003fooooo`008Oooool00ol0003oooooooooo`3eooooo`008Oooool00ol0003oooooooooo`3e
ooooo`008Oooool00ol0003oooooooooo`3eooooo`008Oooool2o`000?Kooooo000Qooooo`03o`00
0?oooooooooo0?Gooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`03o`000?oooooo
oooo0?Gooooo000Qooooo`;o0000m_ooool000Sooooo0_l00004ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000ooooooooool0mOooool000Oooooo
00Co0000oooooooooooo00002Oooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`3eooooo`001oooool01?l0003oooooooooool0000:oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3eoooo
o`001oooool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool00_ooool2o`000?Kooooo0007ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000oooo
ool000000ol00005ooooo`03o`000?oooooooooo0?Gooooo0007ooooo`04o`000?ooooooooooo`00
00Oooooo00Oo0000ooooooooooooooooo`000?oooooo000000Sooooo00?o0000ooooooooool0mOoo
ool000Sooooo0_l00008ooooo`Go000000?oooooo`000?l000000ol00004ooooo`03o`000?oooooo
oooo0?Gooooo000Qooooo`;o0000m_ooool0027ooooo00?o0000ooooooooool0mOooool0027ooooo
00?o0000ooooooooool0mOooool0027ooooo00?o0000ooooooooool0mOooool0027ooooo0_l0003f
ooooo`008Oooool00ol0003oooooooooo`3eooooo`008Oooool00ol0003oooooooooo`3eooooo`00
8Oooool2o`000?Kooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`03o`000?oooooo
oooo0?Gooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`;o0000m_ooool0027ooooo
00?o0000ooooooooool0mOooool001Wooooo0ol00005ooooo`03o`000?oooooooooo0?Gooooo000J
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0mOooool001[ooooo00?o0000oooo
ooooool01?ooool2o`000?Kooooo000Jooooo`03o`000?oooooooooo0?cooooo000Jooooo`03o`00
0?oooooooooo0?cooooo000Iooooo`;o0000o_ooool001[ooooo00?o0000ooooooooool0o?ooool0
0?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00001\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-0.411907, -1.10464, \
0.0124173, 0.0127565}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(amplitude = 
      s2[t] /. c3_\ Exp[c4_]\ \((c1_\ Cos[a_] + c2_\ Sin[a_])\) \[Rule] 
          c3\ \@\(c1\^2 + c2\^2\)\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-\(2\/\@13\)\)\)], "Output"]
}, Closed]],

Cell[TextData["The exponential envelopes are:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(p2 = 
      Plot[{amplitude\ Exp[\(-t\)], \(-amplitude\)\ Exp[\(-t\)]}, {t, 0, 
          3}]\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.309017 0.53056 [
[.18254 .29652 -9 -9 ]
[.18254 .29652 9 0 ]
[.34127 .29652 -3 -9 ]
[.34127 .29652 3 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .09679 -24 -4.5 ]
[.01131 .09679 0 4.5 ]
[.01131 .2029 -24 -4.5 ]
[.01131 .2029 0 4.5 ]
[.01131 .41513 -18 -4.5 ]
[.01131 .41513 0 4.5 ]
[.01131 .52124 -18 -4.5 ]
[.01131 .52124 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .30902 m
.18254 .31527 L
s
[(0.5)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(1)] .34127 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(2)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .09679 m
.03006 .09679 L
s
[(-0.4)] .01131 .09679 1 0 Mshowa
.02381 .2029 m
.03006 .2029 L
s
[(-0.2)] .01131 .2029 1 0 Mshowa
.02381 .41513 m
.03006 .41513 L
s
[(0.2)] .01131 .41513 1 0 Mshowa
.02381 .52124 m
.03006 .52124 L
s
[(0.4)] .01131 .52124 1 0 Mshowa
.125 Mabswid
.02381 .12332 m
.02756 .12332 L
s
.02381 .14985 m
.02756 .14985 L
s
.02381 .17638 m
.02756 .17638 L
s
.02381 .22943 m
.02756 .22943 L
s
.02381 .25596 m
.02756 .25596 L
s
.02381 .28249 m
.02756 .28249 L
s
.02381 .33555 m
.02756 .33555 L
s
.02381 .36207 m
.02756 .36207 L
s
.02381 .3886 m
.02756 .3886 L
s
.02381 .44166 m
.02756 .44166 L
s
.02381 .46819 m
.02756 .46819 L
s
.02381 .49471 m
.02756 .49471 L
s
.02381 .07026 m
.02756 .07026 L
s
.02381 .04374 m
.02756 .04374 L
s
.02381 .01721 m
.02756 .01721 L
s
.02381 .54777 m
.02756 .54777 L
s
.02381 .5743 m
.02756 .5743 L
s
.02381 .60083 m
.02756 .60083 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .04844 L
.10458 .08083 L
.14415 .10757 L
.18221 .13033 L
.22272 .15173 L
.26171 .16991 L
.30316 .18694 L
.34309 .20137 L
.3815 .21364 L
.42237 .22516 L
.46172 .23493 L
.49955 .24326 L
.53984 .25109 L
.57861 .25775 L
.61984 .264 L
.65954 .26929 L
.69774 .27379 L
.73838 .27803 L
.77751 .28162 L
.81909 .28498 L
.85916 .28783 L
.89771 .29026 L
.93871 .29253 L
.97619 .29436 L
s
.02381 .60332 m
.06244 .5696 L
.10458 .53721 L
.14415 .51046 L
.18221 .48771 L
.22272 .4663 L
.26171 .44812 L
.30316 .4311 L
.34309 .41667 L
.3815 .4044 L
.42237 .39288 L
.46172 .3831 L
.49955 .37478 L
.53984 .36694 L
.57861 .36028 L
.61984 .35404 L
.65954 .34874 L
.69774 .34424 L
.73838 .34001 L
.77751 .33641 L
.81909 .33305 L
.85916 .3302 L
.89771 .32778 L
.93871 .32551 L
.97619 .32367 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{17, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJ
ooooo`00oooooolJooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003ooooo
ooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool2o`000?cooooo000Koooo
o`?o0000noooool001_ooooo00Co0000oooooooooooo0000n_ooool001_ooooo00Go0000oooooooo
ooooooooo`00003iooooo`006oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?Ko
oooo000Kooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0mOooool001_ooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`3dooooo`006oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo0??ooooo000Kooooo`;o00001oooool00ol0003oooooooooo`3boooo
o`006oooool00ol0003oooooooooo`07ooooo`;o0000l_ooool001_ooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`3_ooooo`006oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo0>kooooo000Kooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0kOooool0
01_ooooo00?o0000ooooooooool03?ooool2o`000>gooooo000Kooooo`03o`000?oooooooooo00ko
oooo00?o0000ooooooooool0j_ooool001_ooooo0_l0000@ooooo`03o`000?oooooooooo0>Wooooo
000Kooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0j?ooool001_ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`3Wooooo`006oooool00ol0003oooooooooo`0Boooo
o`;o0000ioooool000Sooooo0_l00004ooooo`03o`000?oooooooooo00?ooooo0ol00004ooooo`03
o`000?oooooooooo01Cooooo00?o0000ooooooooool0i?ooool000Oooooo00Co0000oooooooooooo
00002_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Gooooo0_l0003Tooooo`00
1Ol00002ooooo`04o`000?ooooooooooo`0000Oooooo1Ol00004ooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool0hOooool000Oooooo00Co0000oooooooooooo00001oooool01?l0003o
ooooooooool00005ooooo`;o00006Oooool00ol0003oooooooooo`3Pooooo`001oooool01?l0003o
ooooooooool00008ooooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool06Oooool2o`00
0>3ooooo0007ooooo`04o`000?ooooooooooo`0000Wooooo0_l00005ooooo`03o`000?oooooooooo
01_ooooo00?o0000ooooooooool0gOooool000Sooooo0_l0000;ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool07?ooool2o`000=gooooo000Kooooo`03o`000?oooooooooo01kooooo
0_l0003Kooooo`006oooool00ol0003oooooooooo`0Pooooo`;o0000fOooool001_ooooo00?o0000
ooooooooool08_ooool2o`000=Oooooo000Kooooo`;o00009Oooool2o`000=Gooooo000Kooooo`03
o`000?oooooooooo02Kooooo0_l0003Cooooo`006oooool00ol0003oooooooooo`0Xooooo`;o0000
dOooool001_ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`3>ooooo`006oooool0
0ol0003oooooooooo`0[ooooo`;o0000c_ooool001_ooooo00?o0000ooooooooool0;Oooool2o`00
0<cooooo000Kooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool0bOooool001_ooooo
0_l0000aooooo`;o0000bOooool001_ooooo00?o0000ooooooooool0<_ooool2o`000<Oooooo000K
ooooo`03o`000?oooooooooo03Cooooo0ol00034ooooo`006oooool00ol0003oooooooooo`0goooo
o`;o0000`_ooool001_ooooo00?o0000ooooooooool0>Oooool2o`000<3ooooo000Kooooo`03o`00
0?oooooooooo03_ooooo0_l0002nooooo`006oooool2o`0003kooooo0ol0002kooooo`006oooool0
0ol0003oooooooooo`10ooooo`;o0000^Oooool001_ooooo00?o0000ooooooooool0@_ooool3o`00
0;Kooooo000Kooooo`03o`000?oooooooooo04Gooooo0_l0002dooooo`006oooool00ol0003ooooo
ooooo`17ooooo`?o0000/Oooool000Sooooo0_l00004ooooo`04o`000?ooooooooooooooo`Go0000
1?ooool00ol0003oooooooooo`1:ooooo`?o0000[_ooool000Oooooo00Co0000oooooooooooo0000
2?ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo04gooooo0ol0002[ooooo`00
1Ol00002ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool01?ooool2o`00057o
oooo0ol0002Xooooo`001oooool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool0Doooool3o`000:Gooooo0007ooooo`04o`000?ooooooooooo`0000Oo
oooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo05Kooooo0ol0002Roooo
o`001oooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool0
0ol0003oooooooooo`1Iooooo`Co0000W_ooool000Sooooo0_l00009ooooo`?o00001Oooool00ol0
003oooooooooo`1Mooooo`?o0000Voooool001_ooooo00?o0000ooooooooool0H?ooool3o`0009So
oooo000Kooooo`03o`000?oooooooooo06?ooooo1?l0002Dooooo`006oooool2o`0006Sooooo0ol0
002Aooooo`006oooool00ol0003oooooooooo`1Zooooo`?o0000S_ooool001_ooooo00?o0000oooo
ooooool0KOooool5o`0008Wooooo000Kooooo`03o`000?oooooooooo07;ooooo1Ol00024ooooo`00
6oooool00ol0003oooooooooo`1gooooo`Go0000Ooooool001_ooooo00?o0000ooooooooool0O?oo
ool5o`0007[ooooo000Kooooo`03o`000?oooooooooo087ooooo1_l0001dooooo`006oooool2o`00
08Sooooo1Ol0001_ooooo`006oooool00ol0003oooooooooo`2<ooooo`So0000Ioooool001_ooooo
00?o0000ooooooooool0U?ooool8o`0005oooooo000Kooooo`03o`000?oooooooooo01oooooo0_l0
0004ooooo`03o`000?oooooooooo00;ooooo0ol0000Pooooo`?o00008?ooool3o`0000Cooooo00?o
0000ooooooooool00_ooool3o`0001gooooo2?l0000Nooooo`Go00000oooool00ol0003ooooooooo
o`02ooooo`?o00008?ooool3o`0000Kooooo000Kooooo`03o`000?oooooooooo01kooooo00Co0000
oooooooooooo00001oooool01Ol0003ooooooooooooooooo0000023ooooo00?o0000ooooooooool0
8?ooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool000008?ooool8o`0001_o
oooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000001kooooo00Go0000
ooooooooooooooooo`000005ooooo`006oooool00ol0003oooooooooo`0Nooooo`04o`000?oooooo
ooooo`0000_ooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`0Pooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`04ooooo`[o00004_oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool00ooo
ool001_ooooo00?o0000ooooooooool07_ooool01?l0003oooooooooool0000;ooooo`03o`000?oo
oooooooo01kooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo023ooooo00?o0000ooooooooool03Oooool;o`0000Sooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0Nooooo`;o00001_ooool001_ooooo0_l0000Oooooo`04o`000?oooooo
ooooo`0000Oooooo1?l0000Qooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool01ooo
ool4o`00023ooooo00Go0000ooooooooooooooooo`00000Iooooo`[o00001oooool4o`0002?ooooo
00?o0000ooooooooool00oooool001_ooooo00?o0000ooooooooool07_ooool01?l0003ooooooooo
ool00007ooooo`03o`000?oooooooooo027ooooo0_l0000Qooooo`;o00002Oooool00ol0003ooooo
ooooo`0Qooooo`05o`000?ooooooooooooooool000007_ooool01?l0003ooooooooooooooolFo`00
01Gooooo00Go0000ooooooooooooooooo`000005ooooo`006oooool00ol0003oooooooooo`0Ooooo
o`;o00002?ooool5o`00023ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`07oooo
o`Go00008?ooool3o`00023ooooo0ol00008ooooo`Go00002Oooool:o`0000cooooo0ol00006oooo
o`006oooool00ol0003oooooooooo`3Vooooo`oo00001_ooool001_ooooo00?o0000ooooooooool0
noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool0
01Goooooool00005o`0000006oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`006oooool00ol0003ooooo
ooooo`0Vooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool09_ooool00ol0003ooooo
ooooo`0Wooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool09_ooool00ol0003ooooo
ooooo`04ooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3U
oooooa3o00001_ooool001_ooooo00?o0000ooooooooool0dOoooolDo`0001Kooooo000Kooooo`03
o`000?oooooooooo0<Kooooo2ol0000Zooooo`006oooool2o`000;gooooo2_l0000eooooo`006ooo
ool00ol0003oooooooooo`2aooooo`_o0000?oooool001_ooooo00?o0000ooooooooool0Yoooool:
o`0004[ooooo000Kooooo`03o`000?oooooooooo0:3ooooo1ol0001Dooooo`006oooool00ol0003o
ooooooooo`2Kooooo`Go0000Foooool001_ooooo00?o0000ooooooooool0Toooool8o`00063ooooo
000Kooooo`03o`000?oooooooooo08_ooooo2?l0001Xooooo`006oooool2o`0008Oooooo1Ol0001`
ooooo`006oooool00ol0003oooooooooo`20ooooo`Ko0000MOooool001_ooooo00?o0000oooooooo
ool0Noooool5o`0007_ooooo000Kooooo`03o`000?oooooooooo07Kooooo1Ol00020ooooo`006ooo
ool00ol0003oooooooooo`1aooooo`Go0000QOooool001_ooooo00?o0000ooooooooool0K?ooool5
o`0008[ooooo000Kooooo`03o`000?oooooooooo06Wooooo0ol0002?ooooo`006oooool2o`0006Oo
oooo0ol0002Booooo`006oooool00ol0003oooooooooo`1Rooooo`Co0000UOooool001_ooooo00?o
0000ooooooooool0Goooool3o`0009Wooooo000Kooooo`03o`000?oooooooooo05cooooo0ol0002L
ooooo`002?ooool2o`0000Cooooo00Co0000oooooooooooooooo1Ol00004ooooo`03o`000?oooooo
oooo05Sooooo1?l0002Oooooo`001oooool01?l0003oooooooooool00008ooooo`04o`000?oooooo
ooooo`0000Cooooo00?o0000ooooooooool0EOooool3o`000:?ooooo0007ooooo`04o`000?oooooo
ooooo`0000Wooooo00?o0000ooooooooool01?ooool2o`0005?ooooo0ol0002Vooooo`001oooool0
1?l0003oooooooooool0000:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Cooo
ool3o`000:Wooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooooooooooo
o`000004ooooo`03o`000?oooooooooo04cooooo0ol0002/ooooo`001oooool01?l0003ooooooooo
ool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`19ooooo`?o
0000[oooool000Sooooo0_l00009ooooo`?o00001Oooool00ol0003oooooooooo`16ooooo`?o0000
/_ooool001_ooooo00?o0000ooooooooool0A?ooool2o`000;Gooooo000Kooooo`03o`000?oooooo
oooo047ooooo0ol0002gooooo`006oooool2o`00043ooooo0_l0002jooooo`006oooool00ol0003o
ooooooooo`0looooo`?o0000_?ooool001_ooooo00?o0000ooooooooool0>_ooool2o`000;oooooo
000Kooooo`03o`000?oooooooooo03Sooooo0_l00031ooooo`006oooool00ol0003oooooooooo`0e
ooooo`?o0000`oooool001_ooooo00?o0000ooooooooool0<oooool2o`000<Kooooo000Kooooo`03
o`000?oooooooooo037ooooo0_l00038ooooo`006oooool2o`00033ooooo0_l0003:ooooo`006ooo
ool00ol0003oooooooooo`0]ooooo`;o0000c?ooool001_ooooo00?o0000ooooooooool0:oooool2
o`000<kooooo000Kooooo`03o`000?oooooooooo02Wooooo0_l0003@ooooo`006oooool00ol0003o
ooooooooo`0Wooooo`;o0000d_ooool001_ooooo00?o0000ooooooooool09Oooool2o`000=Cooooo
000Kooooo`03o`000?oooooooooo02?ooooo0_l0003Fooooo`006oooool2o`0002?ooooo00?o0000
ooooooooool0e_ooool001_ooooo00?o0000ooooooooool08?ooool2o`000=Wooooo000Kooooo`03
o`000?oooooooooo01kooooo0_l0003Kooooo`006oooool00ol0003oooooooooo`0Mooooo`03o`00
0?oooooooooo0=_ooooo000Kooooo`03o`000?oooooooooo01_ooooo0_l0003Nooooo`002?ooool2
o`0000Cooooo00?o0000ooooooooool00oooool3o`0000Cooooo00?o0000ooooooooool06_ooool0
0ol0003oooooooooo`3Nooooo`001oooool01?l0003oooooooooool0000:ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool06?ooool2o`000>7ooooo0007ooooo`04o`000?oooooooooo
o`0000Oooooo1Ol00004ooooo`;o00006?ooool00ol0003oooooooooo`3Qooooo`001oooool01?l0
003oooooooooool00007ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool05_oo
ool00ol0003oooooooooo`3Rooooo`001oooool01?l0003oooooooooool00008ooooo`03o`000?oo
oooo000000Gooooo00?o0000ooooooooool05?ooool2o`000>Gooooo0007ooooo`04o`000?oooooo
ooooo`0000Wooooo0_l00005ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0iOoo
ool000Sooooo0_l0000;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool04Oooool2
o`000>Sooooo000Kooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0j?ooool001_o
oooo00?o0000ooooooooool03oooool00ol0003oooooooooo`3Yooooo`006oooool2o`0000oooooo
00?o0000ooooooooool0j_ooool001_ooooo00?o0000ooooooooool03?ooool2o`000>gooooo000K
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0kOooool001_ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`3^ooooo`006oooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo0>oooooo000Kooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
l?ooool001_ooooo00?o0000ooooooooool01_ooool2o`000??ooooo000Kooooo`;o00001_ooool0
0ol0003oooooooooo`3cooooo`006oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
0?Cooooo000Kooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0mOooool001_ooooo
00Co0000oooooooooooooooo0_l0003hooooo`006oooool01?l0003oooooooooool0003jooooo`00
6oooool00ol0003oooooo`00003kooooo`006oooool2o`000?cooooo000Kooooo`;o0000o?ooool0
01_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo
00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool00?oooooo6_ooool0
0?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool0
0001\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-0.330441, -0.628352, \
0.0121272, 0.00725628}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[TextData["The plot and the envelopes:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[p1, p2]\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.309017 0.309017 [
[.18254 .29652 -9 -9 ]
[.18254 .29652 9 0 ]
[.34127 .29652 -3 -9 ]
[.34127 .29652 3 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 0 -12 -4.5 ]
[.01131 0 0 4.5 ]
[.01131 .07725 -30 -4.5 ]
[.01131 .07725 0 4.5 ]
[.01131 .15451 -24 -4.5 ]
[.01131 .15451 0 4.5 ]
[.01131 .23176 -30 -4.5 ]
[.01131 .23176 0 4.5 ]
[.01131 .38627 -24 -4.5 ]
[.01131 .38627 0 4.5 ]
[.01131 .46353 -18 -4.5 ]
[.01131 .46353 0 4.5 ]
[.01131 .54078 -24 -4.5 ]
[.01131 .54078 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .30902 m
.18254 .31527 L
s
[(0.5)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(1)] .34127 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(2)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 0 m
.03006 0 L
s
[(-1)] .01131 0 1 0 Mshowa
.02381 .07725 m
.03006 .07725 L
s
[(-0.75)] .01131 .07725 1 0 Mshowa
.02381 .15451 m
.03006 .15451 L
s
[(-0.5)] .01131 .15451 1 0 Mshowa
.02381 .23176 m
.03006 .23176 L
s
[(-0.25)] .01131 .23176 1 0 Mshowa
.02381 .38627 m
.03006 .38627 L
s
[(0.25)] .01131 .38627 1 0 Mshowa
.02381 .46353 m
.03006 .46353 L
s
[(0.5)] .01131 .46353 1 0 Mshowa
.02381 .54078 m
.03006 .54078 L
s
[(0.75)] .01131 .54078 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .01545 m
.02756 .01545 L
s
.02381 .0309 m
.02756 .0309 L
s
.02381 .04635 m
.02756 .04635 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .10816 m
.02756 .10816 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .13906 m
.02756 .13906 L
s
.02381 .16996 m
.02756 .16996 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .20086 m
.02756 .20086 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26266 m
.02756 .26266 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .29357 m
.02756 .29357 L
s
.02381 .32447 m
.02756 .32447 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .35537 m
.02756 .35537 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .41717 m
.02756 .41717 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .44807 m
.02756 .44807 L
s
.02381 .47898 m
.02756 .47898 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .50988 m
.02756 .50988 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57168 m
.02756 .57168 L
s
.02381 .58713 m
.02756 .58713 L
s
.02381 .60258 m
.02756 .60258 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .15451 m
.02605 .15249 L
.02846 .15071 L
.03072 .14939 L
.03279 .14848 L
.03405 .14806 L
.03521 .14777 L
.03649 .14755 L
.03713 .14748 L
.03784 .14743 L
.03903 .14743 L
.04031 .14752 L
.04151 .14771 L
.04262 .14795 L
.04384 .14832 L
.04514 .14881 L
.04748 .14994 L
.05026 .15172 L
.05278 .15372 L
.06244 .16458 L
.06787 .17272 L
.07287 .18136 L
.08414 .20425 L
.10458 .25364 L
.125 .30553 L
.14407 .34893 L
.15348 .36683 L
.16239 .38102 L
.16732 .38759 L
.17267 .39367 L
.17718 .3979 L
.18204 .40153 L
.18457 .40304 L
.18689 .4042 L
.18924 .40515 L
.19144 .40583 L
.19261 .40612 L
.19385 .40636 L
.19456 .40647 L
.19524 .40656 L
.19649 .40668 L
.19714 .40671 L
.19782 .40673 L
.19905 .40672 L
.20036 .40664 L
.20111 .40657 L
.20181 .40648 L
.20311 .40627 L
.20453 .40597 L
.20711 .40523 L
Mistroke
.20961 .40428 L
.21194 .4032 L
.21721 .40008 L
.22282 .39579 L
.23313 .38558 L
.24427 .37179 L
.26446 .34223 L
.28404 .31211 L
.30551 .28275 L
.31539 .27177 L
.32597 .2623 L
.3311 .25864 L
.33596 .25575 L
.34065 .25352 L
.34505 .25191 L
.34727 .25128 L
.34965 .25074 L
.35095 .25051 L
.3523 .2503 L
.35346 .25016 L
.35473 .25005 L
.35543 .25 L
.35608 .24997 L
.35731 .24993 L
.35863 .24994 L
.35937 .24996 L
.36005 .24998 L
.3612 .25006 L
.36246 .25017 L
.36377 .25033 L
.365 .25051 L
.36739 .25096 L
.36965 .2515 L
.37389 .2528 L
.37846 .25461 L
.38343 .25702 L
.40318 .27042 L
.42418 .28896 L
.4619 .32243 L
.47131 .32914 L
.48122 .33504 L
.48641 .33761 L
.4921 .33998 L
.49688 .34161 L
.50207 .34299 L
.50481 .34356 L
.50735 .34399 L
.50977 .3443 L
.511 .34443 L
.51233 .34455 L
Mistroke
.51353 .34463 L
.51462 .34468 L
.51572 .34472 L
.51677 .34474 L
.51798 .34474 L
.51911 .34473 L
.52034 .34469 L
.52166 .34463 L
.52307 .34454 L
.52438 .34443 L
.52732 .34409 L
.52991 .3437 L
.53264 .3432 L
.5426 .34062 L
.55209 .33719 L
.56225 .33266 L
.58059 .323 L
.60042 .31181 L
.62197 .30074 L
.63202 .29645 L
.64269 .29273 L
.65179 .2903 L
.65697 .28924 L
.66184 .28846 L
.66654 .28792 L
.6692 .2877 L
.67168 .28755 L
.67303 .28749 L
.6743 .28745 L
.67545 .28743 L
.67669 .28741 L
.67733 .28741 L
.67804 .28741 L
.67878 .28742 L
.67947 .28743 L
.68071 .28746 L
.6814 .28748 L
.68204 .28751 L
.6844 .28762 L
.68658 .28777 L
.69153 .28825 L
.6959 .28882 L
.70055 .28958 L
.71087 .29176 L
.72201 .29474 L
.7422 .30121 L
.7618 .30789 L
.78328 .31446 L
.79317 .31695 L
.80375 .31912 L
Mistroke
.80889 .31996 L
.81374 .32063 L
.81844 .32116 L
.82283 .32155 L
.82524 .32171 L
.82744 .32184 L
.82989 .32195 L
.83124 .32199 L
.83252 .32203 L
.83376 .32205 L
.83507 .32207 L
.83631 .32208 L
.83744 .32208 L
.83813 .32208 L
.83876 .32207 L
.83946 .32207 L
.8402 .32205 L
.84144 .32203 L
.8428 .32199 L
.84521 .32191 L
.8474 .32181 L
.85233 .3215 L
.8569 .32111 L
.86124 .32066 L
.88114 .31775 L
.89955 .31422 L
.9198 .31004 L
.93881 .30643 L
.95679 .3037 L
.96691 .30256 L
.97619 .3018 L
Mfstroke
.02381 .13761 m
.06244 .15725 L
.10458 .17611 L
.14415 .19169 L
.18221 .20494 L
.22272 .21741 L
.26171 .228 L
.30316 .23791 L
.34309 .24632 L
.3815 .25346 L
.42237 .26017 L
.46172 .26587 L
.49955 .27072 L
.53984 .27528 L
.57861 .27916 L
.61984 .2828 L
.65954 .28588 L
.69774 .2885 L
.73838 .29097 L
.77751 .29306 L
.81909 .29502 L
.85916 .29668 L
.89771 .29809 L
.93871 .29941 L
.97619 .30048 L
s
.02381 .48043 m
.06244 .46079 L
.10458 .44192 L
.14415 .42635 L
.18221 .41309 L
.22272 .40062 L
.26171 .39004 L
.30316 .38012 L
.34309 .37172 L
.3815 .36457 L
.42237 .35786 L
.46172 .35217 L
.49955 .34732 L
.53984 .34275 L
.57861 .33887 L
.61984 .33524 L
.65954 .33216 L
.69774 .32953 L
.73838 .32707 L
.77751 .32497 L
.81909 .32302 L
.85916 .32136 L
.89771 .31994 L
.93871 .31862 L
.97619 .31755 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{17, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJ
ooooo`006Oooool3o`000?gooooo000Jooooo`03o`000?oooooooooo0?cooooo000Booooo`Go0000
0oooool00ol0003oooooooooo`3looooo`006_ooool00ol0003oooooooooo`04ooooo`;o0000m_oo
ool001[ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3eooooo`006Oooool2o`00
00Kooooo00?o0000ooooooooool0mOooool001[ooooo00?o0000ooooooooool01?ooool2o`000?Ko
oooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Q
ooooo`03o`000?oooooooooo0?Gooooo000Qooooo`;o0000m_ooool0027ooooo00?o0000oooooooo
ool0mOooool0027ooooo00?o0000ooooooooool0mOooool0027ooooo00?o0000ooooooooool0mOoo
ool0027ooooo0_l0003fooooo`008Oooool00ol0003oooooooooo`3eooooo`008Oooool00ol0003o
ooooooooo`3eooooo`008Oooool00ol0003oooooooooo`3eooooo`008Oooool2o`000?Kooooo000Q
ooooo`03o`000?oooooooooo0?Gooooo0008ooooo`;o00001?ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`000?oooooooooo0?Gooooo0007ooooo`04
o`000?ooooooooooo`0000Wooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0mOooool000Go00000_ooool01?l0003oooooooooool0000:
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool2o`000?Kooooo0007oooo
o`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo0?Gooooo0007ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000
ooooool000000ol00005ooooo`03o`000?oooooooooo0?Gooooo0007ooooo`04o`000?oooooooooo
o`0000Oooooo00Oo0000ooooooooooooooooo`000?oooooo000000Sooooo00?o0000ooooooooool0
mOooool000Sooooo0_l00008ooooo`Go000000?oooooo`000?l000000ol00004ooooo`;o0000m_oo
ool0027ooooo00?o0000ooooooooool0mOooool0027ooooo00?o0000ooooooooool0mOooool0027o
oooo00?o0000ooooooooool0mOooool0027ooooo0_l0003fooooo`008Oooool00ol0003ooooooooo
o`3eooooo`008Oooool00ol0003oooooooooo`3eooooo`008Oooool00ol0003oooooooooo`3eoooo
o`008Oooool2o`000?Kooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`03o`000?oo
oooooooo0?Gooooo000Qooooo`;o0000m_ooool0027ooooo1?l0003dooooo`003_ooool2o`0000Co
oooo00?o0000ooooooooool00_ooool3o`0000Gooooo00Co0000oooooooooooooooo0_l0003boooo
o`003Oooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool7
o`000?7ooooo0006ooooo`Go00000_ooool01?l0003oooooooooool0000;ooooo`03o`000?oooooo
oooo00;ooooo0_l00004ooooo`?o0000koooool000gooooo00Co0000oooooooooooo00002oooool0
0ol0003oooooooooo`02ooooo`;o00001Oooool01?l0003oooooo`000?l0003]ooooo`003Oooool0
1?l0003oooooooooool00007ooooo`Co00001Oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00;o0000joooool000gooooo00Co0000oooooooooooo00001oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooooooo0ol0003Xooooo`003_oo
ool2o`0000Sooooo1Ol00004ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00ooo
ool2o`000>Kooooo000Qooooo`;o00002Oooool00ol0003oooooooooo`04ooooo`;o0000i?ooool0
027ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`;o0000h_ooool0027o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`07ooooo`?o0000goooool0027ooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`;o0000gOooool0027ooooo0_l0
000:ooooo`03o`000?oooooooooo00cooooo0ol0003Jooooo`008Oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00kooooo0_l0003Hooooo`008Oooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00oooooo0ol0003Eooooo`008Oooool2o`0000cooooo00?o0000oooooooo
ool04_ooool2o`000=?ooooo000Qooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
4oooool3o`000=3ooooo000Qooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool05_oo
ool3o`000<gooooo000Qooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool06?ooool3
o`000<[ooooo000Qooooo`;o00003_ooool00ol0003oooooooooo`0Kooooo`?o0000aoooool0027o
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Nooooo`Go0000`_ooool000Sooooo
0_l00004ooooo`04o`000?ooooooooooooooo`Go00000_ooool3o`0000Gooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0Rooooo`Go0000_Oooool000Oooooo00Co0000oooooooooooo
00002?ooool01_l0003oooooooooool0003oooooo`0000?ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0>ooooo`03o`000?oooooooooo02Oooooo1?l0002iooooo`001Ol00002oooo
o`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02
ooooo`;o00004?ooool00ol0003oooooooooo`0Zooooo`Co0000]Oooool000Oooooo00Co0000oooo
oooooooo00002_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool03oooool00ol0003oooooooooo`0^ooooo`?o0000/_ooool000Oooooo00Co0000oooo
oooooooo00001oooool01_l0003ooooooooooooooooo0000ooooo`Co00001Oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo037ooooo1Ol0002]ooooo`001oooool01?l0003ooooooooo
ool00007ooooo`07o`000?ooooooooooooooool0003oooooo`000008ooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool0=Oooool5o`000:Sooooo0008ooooo`;o00002Oooool3o`0000;o
oooo1Ol00004ooooo`;o00004Oooool00ol0003oooooooooo`0jooooo`Co0000Y?ooool0027ooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`0kooooo`So0000Woooool0027ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0hooooo`;o00001oooool6o`0009[ooooo000Q
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0=_ooool2o`0000cooooo0_l00000
0ooooooo0000o`000003o`0009Gooooo000Qooooo`;o00004oooool00ol0003oooooooooo`0doooo
o`03o`000?oooooooooo00kooooo0_l00004ooooo`So0000SOooool0027ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`09ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o
00007?ooool00ol0003oooooooooo`03o`0000kooooo00?o0000ooooooooool02Oooool:o`0000;o
oooo00?o0000ooooooooool00_ooool3o`0001oooooo1Ol0000Mooooo`Go00000oooool00ol0003o
ooooooooo`02ooooo`?o00007oooool3o`0000Kooooo000Qooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool02?ooool01?l0003oooooooooool00007ooooo`05o`000?oooooooooooooo
ool000006_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool03_ooool01?l0003oooooooooooooool;o`0001oooooo00Co0000oooooooooooo00007_oo
ool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000007Oooool01Ol0003o
oooooooooooooooo000000Gooooo000Qooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool01oooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo01Oooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00gooooo00?o0000oooo
ooooool02oooool:o`0001Oooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo01oooooo00?o0000ooooooooool00oooool0027ooooo0_l0000Dooooo`03
o`000?oooooooooo00Oooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`0Foooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01oooool:o`0000kooooo00?o0000oooo
ooooool07oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01gooooo0_l00006oooo
o`008Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooo
oooo00001oooool4o`0001Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01oooool4o`0001Cooooo2_l000000ooo
oooo0000ooooo`02ooooo`03o`000?oooooooooo01_ooooo00Go0000ooooooooooooooooo`000007
ooooo`Co00008_ooool00ol0003oooooooooo`03ooooo`008Oooool00ol0003oooooooooo`0Doooo
o`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`0I
ooooo`03o`000?oooooooooo00Cooooo0_l0000Dooooo`03o`000?oooooooooo00Wooooo0_l00009
ooooo`03o`000?oooooooooo01oooooo2ol0000Hooooo`05o`000?ooooooooooooooool000001ooo
ool00ol0003oooooooooo`0Oooooo`05o`000?ooooooooooooooool000001Oooool0027ooooo00?o
0000ooooooooool05?ooool00ol0003oooooooooo`07ooooo`;o00002?ooool5o`0001Kooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`0Cooooo`;o00002_ooool00ol0003ooooooooo
o`07ooooo`Go00007_ooool6o`0000?ooooo5?l00006ooooo`?o00002?ooool5o`0001kooooo0ol0
0006ooooo`008Oooool2o`0001Kooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`0O
ooooo`03o`000?oooooooooo03;ooooo0_l0000@ooooo`Go00002?oooolEo`0002Sooooo000Qoooo
o`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`0Poooo
o`03o`000?oooooooooo02kooooo0ol0000Gooooo`?o00006_oooolNo`0000[ooooo000Qooooo`03
o`000?oooooooooo01Gooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`0Rooooo`03
o`000?oooooooooo02[ooooo0ol0000Mooooo`;o0000=_ooool4o`0000Kooooo000Qooooo`03o`00
0?oooooooooo01Kooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0Sooooo`;o0000
:?ooool2o`0002;ooooo0ol0000[ooooo`So00002_ooool001_oooooo_l00000027ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooool000001Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo000000Gooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Oooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo0_l0
0006ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool4o`0000Kooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Ko00001ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo000Qooooo`03o`000?oooooo
oooo01Oooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooo
oooo01gooooo0ol0000booooo`Co00004?ooool5o`0000Oooooo3ol00006ooooo`008Oooool00ol0
003oooooooooo`0Hooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool0:oooool00ol0
003oooooooooo`0Jooooo`;o0000=_oooolOo`0001Gooooo000Qooooo`;o00006Oooool00ol0003o
ooooooooo`0Rooooo`03o`000?oooooooooo02gooooo00?o0000ooooooooool05oooool2o`0002Co
oooo5?l0000dooooo`008Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo023ooooo
00?o0000ooooooooool0;oooool2o`0001Kooooo00?o0000ooooooooool06_ooool:o`0004Sooooo
000Qooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool08?ooool00ol0003ooooooooo
o`0aooooo`03o`000?oooooooooo017ooooo0_l0000Cooooo`[o0000D_ooool0027ooooo00?o0000
ooooooooool06Oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo03?ooooo0_l0000?
ooooo`;o000000?oooooo`000?l000004_l0001Looooo`008Oooool2o`0001_ooooo00?o0000oooo
ooooool07Oooool00ol0003oooooooooo`0fooooo`?o00001oooool8o`00073ooooo000Qooooo`03
o`000?oooooooooo01[ooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`0iooooo`Wo
0000M_ooool0027ooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0Kooooo`03o`00
0?oooooooooo03Gooooo1ol0001mooooo`008Oooool00ol0003oooooooooo`0Kooooo`03o`000?oo
oooooooo01[ooooo00?o0000ooooooooool0;?ooool:o`0008Cooooo000Qooooo`;o00007Oooool0
0ol0003oooooooooo`0Iooooo`03o`000?oooooooooo02Cooooo2?l0002>ooooo`008Oooool00ol0
003oooooooooo`0Mooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool08?ooool5o`00
09Kooooo000Qooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool05oooool00ol0003o
ooooooooo`0Kooooo`Go0000Voooool0027ooooo00?o0000ooooooooool07_ooool00ol0003ooooo
ooooo`0Eooooo`03o`000?oooooooooo01Oooooo1Ol0002Pooooo`008Oooool2o`0001oooooo00?o
0000ooooooooool05?ooool00ol0003oooooooooo`0Dooooo`Co0000YOooool000Sooooo0_l00004
ooooo`04o`000?ooooooooooooooo`Go00000_ooool3o`0000Gooooo00?o0000ooooooooool07ooo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo013ooooo1Ol0002Yooooo`001oooool0
1?l0003oooooooooool00008ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool04?ooool00ol0003o
ooooooooo`0;ooooo`Ko0000[_ooool000Oooooo00Co0000oooooooooooo00002Oooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool08?ooool00ol0003o
ooooooooo`0?ooooo`03o`000?oooooooooo00Oooooo1Ol0002dooooo`001oooool01?l0003ooooo
ooooool0000:ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool2o`0002;o
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`03ooooo`Go0000^Oooool000Oooooo
00Co0000oooooooooooo00001oooool01_l0003ooooooooooooooooo0000ooooo`Co00001Oooool0
0ol0003oooooooooo`0Rooooo`;o00003?ooool01?l0003oooooooooooooool3o`000;kooooo0007
ooooo`04o`000?ooooooooooo`0000Oooooo00Oo0000ooooooooooooooooo`000?oooooo000000So
oooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000;o
0000`Oooool000Sooooo0_l00009ooooo`?o00000_ooool5o`0000Cooooo0_l0000Vooooo`03o`00
0?oooooooooo00Gooooo1?l00034ooooo`008Oooool00ol0003oooooooooo`0Uooooo`?o00000_oo
ool3o`000<Sooooo000Qooooo`03o`000?oooooooooo02Oooooo1?l0003:ooooo`008Oooool00ol0
003oooooooooo`0Tooooo`?o0000c_ooool0027ooooo0_l0000Rooooo`?o0000dOooool0027ooooo
00?o0000ooooooooool07oooool2o`000=Cooooo000Qooooo`03o`000?oooooooooo01cooooo0ol0
003Fooooo`008Oooool00ol0003oooooooooo`0Jooooo`;o0000fOooool0027ooooo0_l0000Hoooo
o`?o0000foooool0027ooooo00?o0000ooooooooool05Oooool2o`000=kooooo000Qooooo`03o`00
0?oooooooooo01;ooooo0ol0003Pooooo`008Oooool00ol0003oooooooooo`0@ooooo`;o0000hooo
ool0027ooooo0_l0000>ooooo`?o0000iOooool0027ooooo00?o0000ooooooooool02_ooool3o`00
0>Sooooo000>ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003o
ooooooooo`07ooooo`?o0000joooool000gooooo00Co0000oooooooooooo00001oooool01Ol0003o
oooooooooooooooo000000Cooooo00?o0000ooooooooool01Oooool2o`000>kooooo000=ooooo`04
o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool00_ooool2o`0000Cooooo0_l0003`oooo
o`003Oooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo00;ooooo00Co0000oooo
oooooooooooo0_l0003booooo`003Oooool01?l0003oooooooooool00007ooooo`Co00001Oooool0
1?l0003oooooooooool0003dooooo`003Oooool01?l0003oooooooooool00007ooooo`03o`000?oo
oooooooo00Kooooo0ol0003eooooo`003_ooool2o`0000Sooooo1Ol00004ooooo`;o0000m_ooool0
027ooooo00?o0000ooooooooool0mOooool0027ooooo00?o0000ooooooooool0mOooool0027ooooo
00?o0000ooooooooool0mOooool0027ooooo0_l0003fooooo`008Oooool00ol0003oooooooooo`3e
ooooo`008Oooool00ol0003oooooooooo`3eooooo`008Oooool00ol0003oooooooooo`3eooooo`00
8Oooool2o`000?Kooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`03o`000?oooooo
oooo0?Gooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`;o0000m_ooool000Sooooo
0_l00004ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool3o`0000Gooooo
00?o0000ooooooooool0mOooool000Oooooo00Co0000oooooooooooo00002Oooool01Ol0003ooooo
oooooooooooo000000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3eooooo`00
1oooool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`3eooooo`001oooool01?l0003oooooooooool0000:ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool2o`000?Kooooo0007ooooo`04o`00
0?ooooooooooo`0000_ooooo00?o0000ooooool000000ol00005ooooo`03o`000?oooooooooo0?Go
oooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00Oo0000ooooooooooooooooo`000?oooooo
000000Sooooo00?o0000ooooooooool0mOooool000Sooooo0_l00008ooooo`Go000000?oooooo`00
0?l000000ol00004ooooo`03o`000?oooooooooo0?Gooooo000Qooooo`;o0000m_ooool0027ooooo
00?o0000ooooooooool0mOooool0027ooooo00?o0000ooooooooool0mOooool0027ooooo00?o0000
ooooooooool0mOooool0027ooooo0_l0003fooooo`008Oooool00ol0003oooooooooo`3eooooo`00
8Oooool00ol0003oooooooooo`3eooooo`008Oooool2o`000?Kooooo000Qooooo`03o`000?oooooo
oooo0?Gooooo000Qooooo`03o`000?oooooooooo0?Gooooo000Qooooo`03o`000?oooooooooo0?Go
oooo000Qooooo`;o0000m_ooool0027ooooo00?o0000ooooooooool0mOooool001Wooooo0ol00005
ooooo`03o`000?oooooooooo0?Gooooo000Jooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0mOooool001[ooooo00?o0000ooooooooool01?ooool2o`000?Kooooo000Jooooo`03o`00
0?oooooooooo0?cooooo000Jooooo`03o`000?oooooooooo0?cooooo000Iooooo`;o0000o_ooool0
01[ooooo00?o0000ooooooooool0o?ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_oo
ool00?oooooo6_ooool00001\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-0.411907, -1.10464, \
0.0124173, 0.0127565}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
WindowSize->{520, 365},
WindowMargins->{{36, Automatic}, {Automatic, 28}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 39, 0, 65, "Subtitle"],
Cell[1818, 55, 154, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[1997, 63, 81, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2103, 69, 808, 20, 43, "Input"],
Cell[2914, 91, 158, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3109, 99, 122, 3, 27, "Input"],
Cell[3234, 104, 122, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3393, 111, 82, 2, 27, "Input"],
Cell[3478, 115, 17221, 447, 183, 3942, 277, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[20702, 564, 130, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20869, 572, 281, 8, 27, "Input"],
Cell[21153, 582, 66, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21256, 588, 70, 2, 27, "Input"],
Cell[21329, 592, 53, 1, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[21431, 599, 81, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21537, 605, 824, 21, 43, "Input"],
Cell[22364, 628, 132, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22533, 636, 122, 3, 27, "Input"],
Cell[22658, 641, 85, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22780, 647, 113, 2, 27, "Input"],
Cell[22896, 651, 17701, 494, 183, 4596, 326, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[40600, 1147, 130, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40767, 1155, 195, 5, 27, "Input"],
Cell[40965, 1162, 93, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41095, 1168, 87, 2, 27, "Input"],
Cell[41185, 1172, 52, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41274, 1178, 112, 2, 27, "Input"],
Cell[41389, 1182, 61, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41487, 1188, 64, 2, 27, "Input"],
Cell[41554, 1192, 53, 1, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[41656, 1199, 81, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[41762, 1205, 915, 23, 80, "Input"],
Cell[42680, 1230, 150, 3, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[42867, 1238, 168, 5, 27, "Input"],
Cell[43038, 1245, 120, 2, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[43195, 1252, 118, 2, 27, "Input"],
Cell[43316, 1256, 21855, 675, 183, 7070, 487, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[65174, 1933, 130, 3, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[65341, 1941, 179, 4, 68, "Input"],
Cell[65523, 1947, 50, 1, 46, "Output"]
}, Closed]],
Cell[65588, 1951, 105, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[65718, 1957, 153, 4, 43, "Input"],
Cell[65874, 1963, 16509, 448, 183, 4054, 288, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[82386, 2413, 130, 3, 27, "Output"]
}, Closed]],
Cell[82531, 2419, 102, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[82658, 2425, 72, 2, 27, "Input"],
Cell[82733, 2429, 23419, 737, 183, 7868, 539, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[106155, 3168, 130, 3, 27, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

